/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.qa.phaser.ExecutionNode;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessorBuilder;
import org.jboss.qa.phaser.PhaseValidationException;
import org.jboss.qa.phaser.PhaseValidator;

public class PhaseTreeNode {
    private PhaseTreeNode parent;
    private List<PhaseTreeNode> childNodes = new ArrayList<PhaseTreeNode>();
    private Phase phase;
    private Set<PhaseDefinition> phaseDefinitions = new TreeSet<PhaseDefinition>();

    public PhaseTreeNode(Phase phase) {
        this.phase = phase;
    }

    public void addChild(PhaseTreeNode childNode) {
        childNode.parent = this;
        this.childNodes.add(childNode);
    }

    public void validate() throws PhaseValidationException {
        PhaseValidator.validate(this.phase);
        for (PhaseTreeNode node : this.childNodes) {
            node.validate();
        }
    }

    public void buildPhaseDefinitions(Class<?> jobClass) throws Exception {
        this.phaseDefinitions = this.phase.findAllOrderedDefinitions(jobClass);
        for (PhaseTreeNode node : this.childNodes) {
            node.buildPhaseDefinitions(jobClass);
        }
    }

    public List<ExecutionNode> buildExecutionTree(PhaseDefinition<?> parent) {
        ArrayList<ExecutionNode> executionNodes = new ArrayList<ExecutionNode>();
        for (PhaseDefinition pd : this.phaseDefinitions) {
            if (parent != null && pd.getParentId() != null && !pd.getParentId().equals(parent.getId())) continue;
            ExecutionNode executionNode = new ExecutionNode(pd, ((PhaseDefinitionProcessorBuilder)this.phase.getPhaseDefinitionBuilder()).buildProcessor(pd.getAnnotation(), pd.getMethod()));
            for (PhaseTreeNode node : this.childNodes) {
                executionNode.addChildNodes(node.buildExecutionTree(pd));
            }
            executionNodes.add(executionNode);
        }
        return executionNodes;
    }

    public PhaseTreeNode getParent() {
        return this.parent;
    }

    public List<PhaseTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public Phase getPhase() {
        return this.phase;
    }
}

