/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessorBuilder;
import org.jboss.qa.phaser.util.ReflectionUtils;

public class WrappedPhase<B extends PhaseDefinitionProcessorBuilder<A>, A extends Annotation, W extends Annotation>
extends Phase<B, A> {
    private Class<W> annotationWrapperClass = ReflectionUtils.getGenericClass(this.getClass(), 2);

    @Override
    public TreeSet<PhaseDefinition<A>> findAllOrderedDefinitions(Class<?> jobClass) throws Exception {
        TreeSet<PhaseDefinition<A>> phaseDefinitions = new TreeSet<PhaseDefinition<A>>();
        W wrappingAnnotation = jobClass.getAnnotation(this.annotationWrapperClass);
        if (wrappingAnnotation != null) {
            phaseDefinitions.addAll(this.findWrappedDefinitions(wrappingAnnotation, null));
        }
        for (Method m : jobClass.getMethods()) {
            wrappingAnnotation = m.getAnnotation(this.annotationWrapperClass);
            if (wrappingAnnotation == null) continue;
            phaseDefinitions.addAll(this.findWrappedDefinitions(wrappingAnnotation, m));
        }
        return phaseDefinitions;
    }

    private List<PhaseDefinition<A>> findWrappedDefinitions(W wrappingAnnotation, Method method) throws Exception {
        ArrayList<PhaseDefinition<A>> phaseDefinitions = new ArrayList<PhaseDefinition<A>>();
        for (Method m : wrappingAnnotation.annotationType().getMethods()) {
            Class<?> type = m.getReturnType();
            if (!type.isArray() || !type.getComponentType().isAssignableFrom(this.getAnnotationClass())) continue;
            for (Annotation a : (Annotation[])m.invoke(wrappingAnnotation, new Object[0])) {
                phaseDefinitions.add(this.createPhaseDefinition(a, method));
            }
        }
        return phaseDefinitions;
    }

    public Class<W> getAnnotationWrapperClass() {
        return this.annotationWrapperClass;
    }

    public void setAnnotationWrapperClass(Class<W> annotationWrapperClass) {
        this.annotationWrapperClass = annotationWrapperClass;
    }
}

