/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <T> Class<T> getGenericClass(Class<?> parametrizedClass, int pos) {
        return (Class)((ParameterizedType)parametrizedClass.getGenericSuperclass()).getActualTypeArguments()[pos];
    }

    public static <T> T invokeAnnotationMethod(Annotation annotation, Class<? extends Annotation> methodId) {
        for (Method am : annotation.annotationType().getMethods()) {
            if (!am.isAnnotationPresent(methodId)) continue;
            try {
                return (T)am.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("Method {} of annotation {} can not be invoked.", (Object)am.getName(), (Object)annotation.getClass().getName());
            }
        }
        return null;
    }

    private ReflectionUtils() {
    }
}

