/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.commons.lang3.StringUtils;
import org.jboss.qa.phaser.AfterJob;
import org.jboss.qa.phaser.BeforeJob;
import org.jboss.qa.phaser.ErrorReport;
import org.jboss.qa.phaser.ErrorReporter;
import org.jboss.qa.phaser.ExceptionHandling;
import org.jboss.qa.phaser.ExecutionError;
import org.jboss.qa.phaser.ExecutionNode;
import org.jboss.qa.phaser.Inject;
import org.jboss.qa.phaser.InstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private Class<?> jobClass;
    private List<ExecutionNode> roots;
    private Object instance;

    public Executor(Class<?> jobClass, List<ExecutionNode> roots) throws Exception {
        this.jobClass = jobClass;
        this.roots = roots;
        this.instance = jobClass.newInstance();
        this.injectFields();
    }

    public void execute() throws Exception {
        LinkedList<ErrorReport> throwAtEnd = new LinkedList<ErrorReport>();
        this.invokeJobMethods(BeforeJob.class);
        LinkedList<ExecutionNode> nodeQueue = new LinkedList<ExecutionNode>(this.roots);
        boolean finalizeState = false;
        while (!nodeQueue.isEmpty()) {
            ExecutionNode node = (ExecutionNode)nodeQueue.poll();
            ExecutionError err = node.execute(this.instance, finalizeState);
            if (err != null) {
                ExceptionHandling eh = err.getExceptionHandling();
                ErrorReport errorReport = new ErrorReport("Exception thrown by phase execution:", err.getThrowable());
                switch (eh.getReport()) {
                    case THROW_AT_END: {
                        throwAtEnd.add(errorReport);
                        break;
                    }
                    case LOG: {
                        ErrorReporter.report(errorReport);
                        break;
                    }
                    default: {
                        log.debug("Exception by phase execution, continue.");
                    }
                }
                if (eh.getExecution() == ExceptionHandling.Execution.IMMEDIATELY_STOP) break;
                if (eh.getExecution() == ExceptionHandling.Execution.FINALIZE) {
                    finalizeState = true;
                }
            }
            nodeQueue.addAll(node.getChildNodes());
        }
        this.invokeJobMethods(AfterJob.class);
        ErrorReporter.finalErrorReport(throwAtEnd);
    }

    private void invokeJobMethods(Class<? extends Annotation> annotaitonClass) throws Exception {
        for (Method m : this.jobClass.getMethods()) {
            Annotation annotation = m.getAnnotation(annotaitonClass);
            if (annotation == null) continue;
            m.invoke(this.instance, new Object[0]);
        }
    }

    private void injectFields() throws Exception {
        for (final Field field : this.jobClass.getDeclaredFields()) {
            final Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            final Class<?> type = field.getType();
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(type);
            enhancer.setCallback((Callback)new InvocationHandler(){

                public Object invoke(Object o, Method method, Object[] args) throws Throwable {
                    if (StringUtils.isNotEmpty((CharSequence)inject.id())) {
                        return method.invoke(InstanceRegistry.get(inject.id(), type), new Object[0]);
                    }
                    List<Object> instances = InstanceRegistry.get(type);
                    if (instances.size() == 1) {
                        return method.invoke(instances.get(0), args);
                    }
                    if (instances.size() > 1) {
                        log.warn("Can not inject {} in {}: more instances existing", (Object)field.getName(), (Object)Executor.this.jobClass.getCanonicalName());
                    }
                    return method.invoke(null, args);
                }
            });
            log.debug("Creating proxy for {}", (Object)field.getName());
            field.setAccessible(true);
            field.set(this.instance, enhancer.create());
        }
    }
}

