/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;

public final class InstanceRegistry {
    private static Map<String, Object> namedInstances = new HashMap<String, Object>();
    private static Map<Class<?>, List<Object>> typedInstances = new HashMap();

    public static void insert(Object o) {
        InstanceRegistry.insert(o, o.getClass());
        InstanceRegistry.insert(o, ClassUtils.getAllInterfaces(o.getClass()));
        InstanceRegistry.insert(o, ClassUtils.getAllSuperclasses(o.getClass()));
    }

    private static void insert(Object o, List<Class<?>> classes) {
        for (Class<?> c : classes) {
            InstanceRegistry.insert(o, c);
        }
    }

    private static void insert(Object o, Class<?> c) {
        List<Object> instances = typedInstances.get(c);
        if (instances == null) {
            instances = new ArrayList<Object>();
            typedInstances.put(c, instances);
        }
        instances.add(o);
    }

    public static void insert(String id, Object o) {
        namedInstances.put(id, o);
        InstanceRegistry.insert(o);
    }

    public static Object get(String id, Class<?> clazz) {
        Object o = namedInstances.get(id);
        if (o != null && clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        return null;
    }

    public static List<Object> get(Class<?> clazz) {
        List<Object> instances = typedInstances.get(clazz);
        return instances == null ? Collections.emptyList() : instances;
    }

    private InstanceRegistry() {
    }
}

