/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessorBuilder;
import org.jboss.qa.phaser.util.ReflectionUtils;

public class WrappedPhase<B extends PhaseDefinitionProcessorBuilder<A>, A extends Annotation, W extends Annotation>
extends Phase<B, A> {
    private Class<W> annotationWrapperClass = ReflectionUtils.getGenericClass(this.getClass(), 2);

    @Override
    public List<PhaseDefinition<A>> findAllDefinitions(Object job) throws Exception {
        ArrayList<PhaseDefinition<A>> phaseDefinitions = new ArrayList<PhaseDefinition<A>>();
        W wrappingAnnotation = job.getClass().getAnnotation(this.annotationWrapperClass);
        if (wrappingAnnotation != null) {
            phaseDefinitions.addAll(this.findWrappedDefinitions(wrappingAnnotation, job, null));
        }
        for (Method m : job.getClass().getMethods()) {
            wrappingAnnotation = m.getAnnotation(this.annotationWrapperClass);
            if (wrappingAnnotation == null) continue;
            phaseDefinitions.addAll(this.findWrappedDefinitions(wrappingAnnotation, job, m));
        }
        return phaseDefinitions;
    }

    private List<PhaseDefinition<A>> findWrappedDefinitions(W wrappingAnnotation, Object job, Method method) throws Exception {
        ArrayList<PhaseDefinition<A>> phaseDefinitions = new ArrayList<PhaseDefinition<A>>();
        for (Method m : wrappingAnnotation.annotationType().getMethods()) {
            Class<?> type = m.getReturnType();
            if (!type.isArray() || !type.getComponentType().isAssignableFrom(this.getAnnotationClass())) continue;
            for (Annotation a : (Annotation[])m.invoke(wrappingAnnotation, new Object[0])) {
                phaseDefinitions.add(this.createPhaseDefinition(a, job, method));
            }
        }
        return phaseDefinitions;
    }

    public Class<W> getAnnotationWrapperClass() {
        return this.annotationWrapperClass;
    }

    public void setAnnotationWrapperClass(Class<W> annotationWrapperClass) {
        this.annotationWrapperClass = annotationWrapperClass;
    }
}

