/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.jboss.qa.phaser.ExceptionHandling;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.ReportsHandling;

public class PhaseDefinition<A extends Annotation>
implements Comparable<PhaseDefinition> {
    private Object id;
    private Object parentId;
    @NonNull
    private Number order;
    private ExceptionHandling exceptionHandling;
    private boolean runAlways;
    @NonNull
    private Phase phase;
    @NonNull
    private A annotation;
    @NonNull
    private Object job;
    private Method method;
    private ReportsHandling reportsHandling;

    @Override
    public int compareTo(PhaseDefinition o) {
        return Double.compare(this.order.doubleValue(), o.order.doubleValue());
    }

    @ConstructorProperties(value={"id", "parentId", "order", "exceptionHandling", "runAlways", "phase", "annotation", "job", "method", "reportsHandling"})
    public PhaseDefinition(Object id, Object parentId, @NonNull Number order, ExceptionHandling exceptionHandling, boolean runAlways, @NonNull Phase phase, @NonNull A annotation, @NonNull Object job, Method method, ReportsHandling reportsHandling) {
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (phase == null) {
            throw new NullPointerException("phase");
        }
        if (annotation == null) {
            throw new NullPointerException("annotation");
        }
        if (job == null) {
            throw new NullPointerException("job");
        }
        this.id = id;
        this.parentId = parentId;
        this.order = order;
        this.exceptionHandling = exceptionHandling;
        this.runAlways = runAlways;
        this.phase = phase;
        this.annotation = annotation;
        this.job = job;
        this.method = method;
        this.reportsHandling = reportsHandling;
    }

    public Object getId() {
        return this.id;
    }

    public Object getParentId() {
        return this.parentId;
    }

    @NonNull
    public Number getOrder() {
        return this.order;
    }

    public ExceptionHandling getExceptionHandling() {
        return this.exceptionHandling;
    }

    public boolean isRunAlways() {
        return this.runAlways;
    }

    @NonNull
    public Phase getPhase() {
        return this.phase;
    }

    @NonNull
    public A getAnnotation() {
        return this.annotation;
    }

    @NonNull
    public Object getJob() {
        return this.job;
    }

    public Method getMethod() {
        return this.method;
    }

    public ReportsHandling getReportsHandling() {
        return this.reportsHandling;
    }
}

