/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.registry;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.commons.lang3.StringUtils;
import org.jboss.qa.phaser.Inject;
import org.jboss.qa.phaser.processors.FieldProcessor;
import org.jboss.qa.phaser.processors.ParameterProcessor;
import org.jboss.qa.phaser.registry.InstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectAnnotationProcessor
implements FieldProcessor<Inject>,
ParameterProcessor<Inject> {
    private static final Logger log = LoggerFactory.getLogger(InjectAnnotationProcessor.class);
    private InstanceRegistry registry;

    @Override
    public Object processField(final Class clazz, final Inject annotation) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] args) throws Throwable {
                if (clazz.isAssignableFrom(InstanceRegistry.class)) {
                    return method.invoke((Object)InjectAnnotationProcessor.this.registry, args);
                }
                if (StringUtils.isNotEmpty((CharSequence)annotation.id())) {
                    return method.invoke(InjectAnnotationProcessor.this.registry.get(annotation.id(), clazz), args);
                }
                List instances = InjectAnnotationProcessor.this.registry.get(clazz);
                if (instances.size() == 1) {
                    return method.invoke(instances.get(0), args);
                }
                if (instances.size() > 1) {
                    log.warn("Can not inject {}: more instances existing", (Object)clazz);
                }
                return method.invoke(null, args);
            }
        });
        return enhancer.create();
    }

    @Override
    public Object processField(Class clazz, Inject annotation, Object value) {
        return this.processField(clazz, annotation);
    }

    @Override
    public Class<Inject> getAnnotationClass() {
        return Inject.class;
    }

    @Override
    public List<Object> processParameter(Class clazz, Inject annotation) {
        if (clazz.isAssignableFrom(InstanceRegistry.class)) {
            return Collections.singletonList(this.registry);
        }
        if (annotation != null && !annotation.id().isEmpty()) {
            return Collections.singletonList(this.registry.get(annotation.id(), clazz));
        }
        return this.registry.get(clazz);
    }

    @ConstructorProperties(value={"registry"})
    public InjectAnnotationProcessor(InstanceRegistry registry) {
        this.registry = registry;
    }
}

