/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reloaded.naming.deployers;

import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.plugins.scope.ApplicationScope;
import org.jboss.metadata.plugins.scope.DeploymentScope;
import org.jboss.reloaded.naming.deployers.dependency.ParentsLookupStrategy;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;
import org.jboss.reloaded.naming.deployers.mc.MCJavaEEModule;
import org.jboss.reloaded.naming.deployers.util.AnnotationHelper;
import org.jboss.reloaded.naming.spi.JavaEEApplication;

public class ModuleNamingDeployer
extends AbstractRealDeployer {
    private JavaEEModuleInformer informer;

    public ModuleNamingDeployer(JavaEEModuleInformer informer) {
        this.informer = informer;
        this.setInputs(informer.getRequiredAttachments());
        this.addInput("java:app");
        this.setOutput(BeanMetaData.class);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (!this.isJavaEEModule(unit)) {
            return;
        }
        String appName = this.informer.getApplicationName(unit);
        String name = this.informer.getModulePath(unit);
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"java:module", (String)MCJavaEEModule.class.getName()).addAnnotation(AnnotationHelper.annotation(DeploymentScope.class, name)).addConstructorParameter(String.class.getName(), name);
        if (appName != null) {
            builder.addAnnotation(AnnotationHelper.annotation(ApplicationScope.class, appName));
            AbstractInjectionValueMetaData javaApp = new AbstractInjectionValueMetaData((Object)"java:app");
            javaApp.setSearch((SearchInfo)new ParentsLookupStrategy());
            builder.addConstructorParameter(JavaEEApplication.class.getName(), (ValueMetaData)javaApp);
        } else {
            builder.addConstructorParameter(JavaEEApplication.class.getName(), (Object)null);
        }
        builder.addPropertyMetaData("nameSpaces", builder.createInject((Object)"NameSpaces"));
        unit.addAttachment("java:module:" + BeanMetaData.class, (Object)builder.getBeanMetaData());
    }

    protected boolean isJavaEEModule(DeploymentUnit unit) {
        JavaEEModuleInformer.ModuleType type = this.informer.getModuleType(unit);
        return type != null && type != JavaEEModuleInformer.ModuleType.JAVA;
    }
}

