/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reloaded.naming.deployers;

import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.plugins.scope.ApplicationScope;
import org.jboss.metadata.plugins.scope.DeploymentScope;
import org.jboss.metadata.plugins.scope.InstanceScope;
import org.jboss.reloaded.naming.deployers.dependency.ParentsLookupStrategy;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.reloaded.naming.deployers.mc.MCJavaEEComponent;
import org.jboss.reloaded.naming.deployers.util.AnnotationHelper;
import org.jboss.reloaded.naming.spi.JavaEEModule;

public class ComponentNamingDeployer
extends AbstractRealDeployer {
    private JavaEEComponentInformer informer;

    public ComponentNamingDeployer(JavaEEComponentInformer informer) {
        this.informer = informer;
        this.setInputs(informer.getRequiredAttachments());
        this.addInput("java:module");
        this.setOutput(BeanMetaData.class);
        this.setComponentsOnly(true);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (!this.informer.isJavaEEComponent(unit)) {
            return;
        }
        String appName = this.informer.getApplicationName(unit);
        String moduleName = this.informer.getModulePath(unit);
        String componentName = this.informer.getComponentName(unit);
        String name = "jboss.naming:";
        if (appName != null) {
            name = name + "application=" + appName + ",";
        }
        name = name + "module=" + moduleName + ",component=" + componentName;
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)name, (String)MCJavaEEComponent.class.getName()).addAnnotation(AnnotationHelper.annotation(DeploymentScope.class, moduleName)).addAnnotation(AnnotationHelper.annotation(InstanceScope.class, componentName)).addConstructorParameter(String.class.getName(), componentName).addAlias((Object)"java:comp");
        if (appName != null) {
            builder.addAnnotation(AnnotationHelper.annotation(ApplicationScope.class, appName));
        }
        AbstractInjectionValueMetaData javaModule = new AbstractInjectionValueMetaData((Object)"java:module");
        javaModule.setSearch((SearchInfo)new ParentsLookupStrategy());
        builder.addConstructorParameter(JavaEEModule.class.getName(), (ValueMetaData)javaModule);
        builder.addPropertyMetaData("nameSpaces", builder.createInject((Object)"NameSpaces"));
        DeploymentUnit component = unit.getParent().addComponent(componentName + ".java:comp");
        component.addAttachment(BeanMetaData.class, (Object)builder.getBeanMetaData());
    }

    protected void internalUndeploy(DeploymentUnit unit) {
        if (!this.informer.isJavaEEComponent(unit)) {
            return;
        }
        String name = this.informer.getComponentName(unit);
        unit.removeComponent(name + ".java:comp");
    }
}

