package org.jboss.reloaded.shrinkwrap.api;
/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptor;
import org.jboss.bootstrap.api.descriptor.ClassLoaderResourceBootstrapDescriptor;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.vfs.TempFileProvider;

/**
 * TODO
 * 
 * Proof-of-concept for ShrinkWrap/Reloaded Integration
 * with {@link MainDeployer}
 * 
 * Expand docs if this prototype works.
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 */
public final class ShrinkWrapReloadedDescriptors
{
   //-------------------------------------------------------------------------------------||
   // Class Members ----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Name of the resource containing a Microcontainer
    * deployment descriptor capable of installing the
    * {@link ShrinkWrapDeployer} implementation
    */
   private static String RESOURCE_NAME_SHRINKWRAP_DEPLOYER = "org.jboss.reloaded_ShrinkWrapDeployer.xml";

   /**
    * Name of the resource containing a Microcontainer
    * deployment descriptor capable of installing the {@link TempFileProvider}
    * used by the {@link ShrinkWrapDeployer}
    */
   public static String RESOURCE_NAME_TEMP_FILE_PROVIDER = "org.jboss.reloaded_TempFileProvider.xml";

   //-------------------------------------------------------------------------------------||
   // Functional Methods -----------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Obtains a {@link BootstrapDescriptor} containing components necessary 
    * for installing the {@link ShrinkWrapDeployer}.
    * The descriptor will be found as a {@link ClassLoader} resource
    * of name {@link ShrinkWrapReloadedDescriptors#RESOURCE_NAME_SHRINKWRAP_DEPLOYER} from the Thread
    * Context ClassLoader
    * @return
    */
   public static BootstrapDescriptor getShrinkWrapDeployerDescriptor()
   {
      // Return
      return new ClassLoaderResourceBootstrapDescriptor(RESOURCE_NAME_SHRINKWRAP_DEPLOYER);
   }

   /**
    * Obtains a {@link BootstrapDescriptor} containing components necessary 
    * for installing the {@link ShrinkWrapDeployer}.
    * The descriptor will be found as a {@link ClassLoader} resource
    * of name {@link ShrinkWrapReloadedDescriptors#RESOURCE_NAME_SHRINKWRAP_DEPLOYER} from the specified
    * @return
    * @param cl {@link ClassLoader} used to obtain the resource
    * @throws IllegalArgumentException If the {@link ClassLoader} is not specified
    */
   public static BootstrapDescriptor getShrinkWrapDeployerDescriptor(final ClassLoader cl)
   {
      // Precondition check
      if (cl == null)
      {
         throw new IllegalArgumentException("ClassLoader must be specified");
      }

      // Return
      return new ClassLoaderResourceBootstrapDescriptor(RESOURCE_NAME_SHRINKWRAP_DEPLOYER, cl);
   }

   /**
    * Obtains a {@link BootstrapDescriptor} containing components necessary 
    * for starting a {@link TempFileProvider} to be used by the {@link ShrinkWrapDeployer}
    * @return
    */
   public static BootstrapDescriptor getTempFileProviderDescriptor()
   {
      // Return
      return new ClassLoaderResourceBootstrapDescriptor(RESOURCE_NAME_TEMP_FILE_PROVIDER);
   }

   /**
    * Obtains a {@link BootstrapDescriptor} containing components necessary 
    * for starting a {@link TempFileProvider} to be used by the {@link ShrinkWrapDeployer}
    * The descriptor will be found as a {@link ClassLoader} resource
    * of name {@link ShrinkWrapReloadedDescriptors#RESOURCE_NAME_TEMP_FILE_PROVIDER} from the specified
    * @return
    * @param cl {@link ClassLoader} used to obtain the resource
    * @throws IllegalArgumentException If the {@link ClassLoader} is not specified
    */
   public static BootstrapDescriptor getTempFileProviderDescriptor(final ClassLoader cl)
   {
      // Precondition check
      if (cl == null)
      {
         throw new IllegalArgumentException("ClassLoader must be specified");
      }

      // Return
      return new ClassLoaderResourceBootstrapDescriptor(RESOURCE_NAME_TEMP_FILE_PROVIDER, cl);
   }

}
