/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.remoting.transport.web.WebUtil;

public class HTTPUnMarshaller
extends SerializableUnMarshaller {
    static final long serialVersionUID = 1085086661310576768L;
    public static final String DATATYPE = "http";
    public static final String PRESERVE_LINES = "preserveLines";
    protected final Logger log = Logger.getLogger(this.getClass());

    public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException {
        if (this.isBinaryData(metadata)) {
            try {
                return super.read(inputStream, metadata, version);
            }
            catch (EOFException e) {
                return null;
            }
        }
        int contentLength = -1;
        String ret = null;
        int bufferSize = 1024;
        byte[] byteBuffer = new byte[bufferSize];
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        boolean preserveLines = false;
        if (metadata != null) {
            Object value = metadata.get("Content-Length");
            if (value == null) {
                value = metadata.get("content-length");
            }
            if (value != null) {
                List valueList;
                if (value instanceof List && (valueList = (List)value) != null && valueList.size() > 0) {
                    value = valueList.get(0);
                }
                if (value instanceof String) {
                    try {
                        contentLength = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        this.log.warn((Object)("Error converting Content-Length value (" + value + ") from metadata into int value."));
                    }
                } else {
                    this.log.warn((Object)"Can not get Content-Length from header for http unmarshalling.");
                }
            }
            if ((value = metadata.get(PRESERVE_LINES)) != null && value instanceof String) {
                preserveLines = Boolean.valueOf((String)value);
            }
        }
        int pointer = 0;
        int amtRead = inputStream.read(byteBuffer);
        while (amtRead > 0) {
            byteOutputStream.write(byteBuffer, pointer, amtRead);
            if (amtRead < bufferSize && byteOutputStream.size() >= contentLength) break;
            amtRead = inputStream.read(byteBuffer);
        }
        byteOutputStream.flush();
        byte[] totalByteArray = byteOutputStream.toByteArray();
        if (totalByteArray.length == 0) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(totalByteArray)));
            StringBuffer buffer = new StringBuffer();
            if (preserveLines) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"preserving cr/lf");
                }
                int len = 0;
                char[] chars = new char[bufferSize];
                while ((len = reader.read(chars)) > -1) {
                    buffer.append(chars, 0, len);
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"deleting cr/lf");
                }
                String str = null;
                while ((str = reader.readLine()) != null) {
                    buffer.append(str);
                }
            }
            reader.close();
            ret = buffer.toString();
        }
        catch (Exception e) {
            this.log.debug((Object)"Can not unmarshall inputstream.  Tried to unmarshall as both an object and string type.", (Throwable)e);
            throw new IOException("Can not unmarshall inputstream.");
        }
        return ret;
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        HTTPUnMarshaller unmarshaller = new HTTPUnMarshaller();
        unmarshaller.setClassLoader(this.getClassLoader());
        return unmarshaller;
    }

    private boolean isErrorReturn(Map metadata) {
        int responseCode;
        Object value;
        boolean isError = false;
        if (metadata != null && (value = metadata.get("ResponseCode")) != null && value instanceof Integer && (responseCode = ((Integer)value).intValue()) > 400) {
            isError = true;
        }
        return isError;
    }

    private boolean isBinaryData(Map metadata) throws IOException {
        boolean isBinary = false;
        if (metadata != null) {
            Object value = metadata.get("Content-Type");
            if (value == null) {
                value = metadata.get("content-type");
            }
            if (value != null) {
                List valueList;
                if (value instanceof List && (valueList = (List)value) != null && valueList.size() > 0) {
                    value = valueList.get(0);
                }
                isBinary = WebUtil.isBinary((String)value);
            }
        }
        return isBinary;
    }
}

