/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.detection.jndi;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import org.jboss.remoting.util.SecurityUtility;
import org.jnp.server.Main;

public class SimpleJNDIServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private int detectorPort = 1099;

    public static void main(String[] args) {
        String prop = System.getProperty("args");
        if (prop != null) {
            try {
                transport = prop.substring(0, prop.indexOf("-"));
                port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
            }
            catch (NumberFormatException nfe) {
                SimpleJNDIServer.println("INVALID ARGUMENTS: Bad port from property args: " + prop);
                System.exit(1);
            }
            catch (Exception e) {
                SimpleJNDIServer.println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
                System.exit(1);
            }
        }
        if (args != null && args.length != 0) {
            if (args.length == 2) {
                transport = args[0];
                port = Integer.parseInt(args[1]);
            } else {
                SimpleJNDIServer.println("INVALID ARGUMENTS: Usage: " + SimpleJNDIServer.class.getName() + " [rmi|socket <port>]");
                System.exit(1);
            }
        }
        SimpleJNDIServer.println("Starting JNDI server... to stop this server, kill it manually via Control-C");
        SimpleJNDIServer server = new SimpleJNDIServer();
        try {
            server.setupJNDIServer();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SimpleJNDIServer.println("Stopping JBoss/Remoting server");
            return;
        }
    }

    private void setupJNDIServer() throws Exception {
        Object namingBean = null;
        Class<?> namingBeanImplClass = null;
        try {
            namingBeanImplClass = Class.forName("org.jnp.server.NamingBeanImpl");
            namingBean = namingBeanImplClass.newInstance();
            Method startMethod = namingBeanImplClass.getMethod("start", new Class[0]);
            SecurityUtility.setSystemProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            startMethod.invoke(namingBean, new Object[0]);
        }
        catch (Exception e) {
            SimpleJNDIServer.println("Cannot find NamingBeanImpl: must be running jdk 1.4");
        }
        String detectorHost = InetAddress.getLocalHost().getHostName();
        Main JNDIServer2 = new Main();
        if (namingBean != null) {
            Class<?> namingBeanClass = Class.forName("org.jnp.server.NamingBean");
            Method setNamingInfoMethod = JNDIServer2.getClass().getMethod("setNamingInfo", namingBeanClass);
            setNamingInfoMethod.invoke((Object)JNDIServer2, namingBean);
        }
        JNDIServer2.setPort(this.detectorPort);
        JNDIServer2.setBindAddress(detectorHost);
        JNDIServer2.start();
        System.out.println("Started JNDI server on " + detectorHost + ":" + this.detectorPort);
    }

    public static void println(String msg) {
        System.out.println(new Date() + ": [SERVER]: " + msg);
    }
}

