/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.util;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.jboss.remoting.loading.RemotingClassLoader;
import org.jboss.remoting.security.ServerSocketFactoryMBean;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SecurityUtility {
    static boolean skipAccessControl;

    public static boolean skipAccessControl() {
        return skipAccessControl;
    }

    public static File createTempFile(final String prefix, final String suffix, final boolean deleteOnExit) throws IOException {
        if (skipAccessControl) {
            File file = File.createTempFile(prefix, suffix);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            return file;
        }
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = File.createTempFile(prefix, suffix);
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                    return file;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void deleteOnExit(final File file) {
        if (file == null) {
            return;
        }
        if (skipAccessControl) {
            file.deleteOnExit();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                file.deleteOnExit();
                return null;
            }
        });
    }

    public static boolean fileExists(final File file) {
        if (file == null) {
            return false;
        }
        if (skipAccessControl) {
            return file.exists();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public static boolean mkdirs(final File dir) {
        if (skipAccessControl) {
            return dir.mkdirs();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(dir.mkdirs());
            }
        });
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (skipAccessControl) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    public static FileInputStream getFileInputStream(final String path) throws FileNotFoundException {
        if (skipAccessControl) {
            return new FileInputStream(path);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    public static FileOutputStream getFileOutputStream(final File file) throws FileNotFoundException {
        if (skipAccessControl) {
            return new FileOutputStream(file);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    public static FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (skipAccessControl) {
            return new FileOutputStream(file, append);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file, append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    public static boolean canRead(final File file) {
        if (skipAccessControl) {
            return file.canRead();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.canRead());
            }
        });
    }

    public static boolean createNewFile(final File file) throws IOException {
        if (skipAccessControl) {
            return file.createNewFile();
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(file.createNewFile());
                }
            });
        }
        catch (Exception e) {
            throw (IOException)e.getCause();
        }
    }

    public static MBeanServer createMBeanServer() throws Exception {
        if (skipAccessControl) {
            return MBeanServerFactory.createMBeanServer();
        }
        try {
            return (MBeanServer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return MBeanServerFactory.createMBeanServer();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static ArrayList findMBeanServer(final String agentId) {
        if (skipAccessControl) {
            return MBeanServerFactory.findMBeanServer(agentId);
        }
        return (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MBeanServerFactory.findMBeanServer(agentId);
            }
        });
    }

    public static Object getMBeanAttribute(final MBeanServer server, final ObjectName objectName, final String attribute) throws Exception {
        if (skipAccessControl) {
            return server.getAttribute(objectName, attribute);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return server.getAttribute(objectName, attribute);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static MBeanServer getPlatformMBeanServer() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (skipAccessControl) {
            Class<?> c = null;
            try {
                c = Class.forName("java.lang.management.ManagementFactory");
            }
            catch (Exception e) {
                System.out.println("Unable to access java.lang.management.ManagementFactory: must be using jdk 1.4");
                return null;
            }
            Method m = c.getMethod("getPlatformMBeanServer", new Class[0]);
            MBeanServer s = (MBeanServer)m.invoke(null, new Object[0]);
            return s;
        }
        try {
            return (MBeanServer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                    Class<?> c = null;
                    try {
                        c = Class.forName("java.lang.management.ManagementFactory");
                    }
                    catch (Exception e) {
                        System.out.println("Unable to access java.lang.management.ManagementFactory: must be using jdk 1.4");
                        return null;
                    }
                    Method m = c.getMethod("getPlatformMBeanServer", new Class[0]);
                    MBeanServer s = (MBeanServer)m.invoke(null, new Object[0]);
                    return s;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw (InvocationTargetException)cause;
        }
    }

    public static boolean isInstanceOf(final MBeanServer server, final ObjectName objectName, final String className) throws InstanceNotFoundException {
        if (skipAccessControl) {
            return server.isInstanceOf(objectName, className);
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(server.isInstanceOf(objectName, className));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (InstanceNotFoundException)e.getCause();
        }
    }

    public static void registerMBean(final MBeanServer server, final Object o, final ObjectName name) throws Exception {
        if (skipAccessControl) {
            server.registerMBean(o, name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    server.registerMBean(o, name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static void unregisterMBean(final MBeanServer server, final ObjectName name) throws Exception {
        if (skipAccessControl) {
            server.unregisterMBean(name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    server.unregisterMBean(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static String getSystemProperty(final String name, final String defaultValue) {
        if (skipAccessControl) {
            return System.getProperty(name, defaultValue);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    public static String getSystemProperty(final String name) {
        if (skipAccessControl) {
            return System.getProperty(name);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    public static void setSystemProperty(final String name, final String value) {
        if (skipAccessControl) {
            System.setProperty(name, value);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.setProperty(name, value);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public static RemotingClassLoader createRemotingClassLoader(ClassLoader remotingClassLoader, ClassLoader userClassLoader) {
        return SecurityUtility.createRemotingClassLoader(remotingClassLoader, userClassLoader, true);
    }

    public static RemotingClassLoader createRemotingClassLoader(final ClassLoader remotingClassLoader, final ClassLoader userClassLoader, final boolean parentFirstDelegation) {
        if (skipAccessControl) {
            return new RemotingClassLoader(remotingClassLoader, userClassLoader, parentFirstDelegation);
        }
        return (RemotingClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new RemotingClassLoader(remotingClassLoader, userClassLoader, parentFirstDelegation);
            }
        });
    }

    public static Object forName(final String className) throws ClassNotFoundException {
        if (skipAccessControl) {
            return Class.forName(className);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getCause();
        }
    }

    public static ClassLoader getClassLoader(final Class c) {
        if (skipAccessControl) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    public static ClassLoader getContextClassLoader(final Thread thread) {
        if (skipAccessControl) {
            return thread.getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return thread.getContextClassLoader();
            }
        });
    }

    public static ClassLoader getSystemClassLoader() {
        if (skipAccessControl) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    public static Method getMethod(final Class c, final String name, final Class[] parameterTypes) throws NoSuchMethodException {
        if (skipAccessControl) {
            return c.getMethod(name, parameterTypes);
        }
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return c.getMethod(name, parameterTypes);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getCause();
        }
    }

    public static Method getDeclaredMethod(final Class c, final String name, final Class[] parameterTypes) throws NoSuchMethodException {
        if (skipAccessControl) {
            Method m = c.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Method m = c.getDeclaredMethod(name, parameterTypes);
                    m.setAccessible(true);
                    return m;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getCause();
        }
    }

    public static void mapJavaBeanProperties(final Object o, final Properties props, final boolean isStrict) throws IntrospectionException {
        if (skipAccessControl) {
            PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IntrospectionException)e.getCause();
        }
    }

    public static void namingBeanImplStart(final Object namingBean, final Method startMethod) throws IllegalAccessException, InvocationTargetException {
        if (skipAccessControl) {
            startMethod.invoke(namingBean, new Object[0]);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    startMethod.invoke(namingBean, new Object[0]);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw (InvocationTargetException)cause;
        }
    }

    public static Object readObject(final ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (skipAccessControl || !(ois instanceof JBossObjectInputStream)) {
            return ois.readObject();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ClassNotFoundException {
                    return ois.readObject();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            throw (RuntimeException)cause;
        }
    }

    public static void writeObject(final ObjectOutputStream oos, final Object o) throws IOException {
        if (skipAccessControl || !(oos instanceof JBossObjectOutputStream)) {
            oos.writeObject(o);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    oos.writeObject(o);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (RuntimeException)cause;
        }
    }

    public static Socket accept(final ServerSocket ss) throws IOException {
        if (skipAccessControl) {
            return ss.accept();
        }
        try {
            return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ss.accept();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void bind(final ServerSocket ss, final SocketAddress address) throws IOException {
        if (skipAccessControl) {
            ss.bind(address);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ss.bind(address);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void bind(final ServerSocket ss, final SocketAddress address, final int backlog) throws IOException {
        if (skipAccessControl) {
            ss.bind(address, backlog);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ss.bind(address, backlog);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void connect(final Socket socket, final InetSocketAddress address) throws IOException {
        if (skipAccessControl) {
            socket.connect(address);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    socket.connect(address);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void connect(final Socket socket, final InetSocketAddress address, final int timeout) throws IOException {
        if (skipAccessControl) {
            socket.connect(address, timeout);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    socket.connect(address, timeout);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void connect(final HttpURLConnection conn) throws IOException {
        if (skipAccessControl) {
            conn.connect();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    conn.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket();
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return ssf.createServerSocket();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf, final int port) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket(port);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf, final int port, final int backlog) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket(port, backlog);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port, backlog);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactoryMBean ssf, final int port, final int backlog, final InetAddress inetAddress) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket(port, backlog, inetAddress);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port, backlog, inetAddress);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactory ssf) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket();
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return ssf.createServerSocket();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactory ssf, final int port) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket(port);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactory ssf, final int port, final int backlog) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket(port, backlog);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port, backlog);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final ServerSocketFactory ssf, final int port, final int backlog, final InetAddress inetAddress) throws IOException {
        if (skipAccessControl) {
            return ssf.createServerSocket(port, backlog, inetAddress);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ssf.createServerSocket(port, backlog, inetAddress);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final int port) throws IOException {
        if (skipAccessControl) {
            return new ServerSocket(port);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ServerSocket(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final int port, final int backlog) throws IOException {
        if (skipAccessControl) {
            return new ServerSocket(port, backlog);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ServerSocket(port, backlog);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ServerSocket createServerSocket(final int port, final int backlog, final InetAddress inetAddress) throws IOException {
        if (skipAccessControl) {
            return new ServerSocket(port, backlog, inetAddress);
        }
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ServerSocket(port, backlog, inetAddress);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static Socket createSocket(final String host, final int port) throws IOException {
        if (skipAccessControl) {
            return new Socket(host, port);
        }
        try {
            return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Socket(host, port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static Socket createSocket(final SocketFactory sf, final String host, final int port) throws IOException {
        if (skipAccessControl) {
            return sf.createSocket(host, port);
        }
        try {
            return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return sf.createSocket(host, port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (skipAccessControl) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (IOException e) {
                return InetAddress.getByName("127.0.0.1");
            }
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (IOException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    public static String getLocalHostName() throws UnknownHostException {
        if (skipAccessControl) {
            return SecurityUtility.getLocalHost().getHostName();
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    InetAddress address = null;
                    try {
                        address = InetAddress.getLocalHost();
                    }
                    catch (IOException e) {
                        address = InetAddress.getByName("127.0.0.1");
                    }
                    return address.getHostName();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    public static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (skipAccessControl) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    public static OutputStream getOutputStream(final HttpURLConnection conn) throws IOException {
        if (skipAccessControl) {
            return conn.getOutputStream();
        }
        try {
            return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return conn.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static int getResponseCode(final HttpURLConnection conn) throws IOException {
        if (skipAccessControl) {
            return conn.getResponseCode();
        }
        try {
            return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Integer(conn.getResponseCode());
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static String getResponseMessage(final HttpURLConnection conn) throws IOException {
        if (skipAccessControl) {
            return conn.getResponseMessage();
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return conn.getResponseMessage();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static Object callTransport(final RMIServerInvokerInf server, final Object payload) throws IOException {
        if (skipAccessControl) {
            return server.transport(payload);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return server.transport(payload);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static Registry createRegistry(final int port) throws RemoteException {
        if (skipAccessControl) {
            return LocateRegistry.createRegistry(port);
        }
        try {
            return (Registry)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return LocateRegistry.createRegistry(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getCause();
        }
    }

    public static Remote exportObject(final Remote object, final int port, final RMIClientSocketFactory csf, final RMIServerSocketFactory ssf) throws RemoteException {
        if (skipAccessControl) {
            return UnicastRemoteObject.exportObject(object, port, csf, ssf);
        }
        try {
            return (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return UnicastRemoteObject.exportObject(object, port, csf, ssf);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getCause();
        }
    }

    public static Registry getRegistry(final int port) throws RemoteException {
        if (skipAccessControl) {
            return LocateRegistry.getRegistry(port);
        }
        try {
            return (Registry)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return LocateRegistry.getRegistry(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getCause();
        }
    }

    public static Remote lookup(final Registry registry, final String name) throws RemoteException, NotBoundException {
        if (skipAccessControl) {
            return registry.lookup(name);
        }
        try {
            return (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return registry.lookup(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                throw (RemoteException)cause;
            }
            throw (NotBoundException)cause;
        }
    }

    public static void rebind(final Registry registry, final String name, final Remote object) throws IOException {
        if (skipAccessControl) {
            registry.rebind(name, object);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    registry.rebind(name, object);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void unbind(final Registry registry, final String name) throws AccessException, RemoteException, NotBoundException {
        if (skipAccessControl) {
            registry.unbind(name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AccessException, RemoteException, NotBoundException {
                    registry.unbind(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AccessException) {
                throw (AccessException)cause;
            }
            if (cause instanceof RemoteException) {
                throw (RemoteException)cause;
            }
            throw (NotBoundException)cause;
        }
    }

    public static Context createSubcontext(final InitialContext initialContext, final String subContextName) throws NamingException {
        if (skipAccessControl) {
            return initialContext.createSubcontext(subContextName);
        }
        try {
            return (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return initialContext.createSubcontext(subContextName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    public static Context initialContextLookup(final InitialContext initialContext, final String subContextName) throws NamingException {
        if (skipAccessControl) {
            return (Context)initialContext.lookup(subContextName);
        }
        try {
            return (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return initialContext.lookup(subContextName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    public static NamingEnumeration listBindings(final Context context, final String bindName) throws NamingException {
        if (skipAccessControl) {
            return context.listBindings(bindName);
        }
        try {
            return (NamingEnumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return context.listBindings(bindName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    public static void rebind(final Context context, final String name, final Object object) throws NamingException {
        if (skipAccessControl) {
            context.rebind(name, object);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    context.rebind(name, object);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    public static void unbind(final Context context, final String name) throws NamingException {
        if (skipAccessControl) {
            context.unbind(name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    context.unbind(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    static {
        try {
            skipAccessControl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    boolean b1 = System.getSecurityManager() == null;
                    boolean b2 = Boolean.getBoolean("skipAccessControl");
                    return new Boolean(b1 || b2);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.getCause().printStackTrace();
        }
    }
}

