/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.SerializableStore;
import org.jboss.remoting.callback.Callback;

public class NullCallbackStore
implements SerializableStore,
Serializable {
    static final long serialVersionUID = -8182007953992756845L;
    private boolean isCallbackLost = false;
    private static final Logger log = Logger.getLogger(NullCallbackStore.class);

    @Override
    public int size() {
        return this.isCallbackLost ? 1 : 0;
    }

    @Override
    public Object getNext() throws IOException {
        if (this.isCallbackLost) {
            this.isCallbackLost = false;
            return new FailedCallback("This is an invalid callback.  The server ran out of memory, so callbacks were lost.");
        }
        return null;
    }

    @Override
    public void add(Serializable object) throws IOException {
        this.isCallbackLost = true;
        log.debug((Object)("Lost callback because not enough free memory available.  Callback lost was " + object));
        throw new IOException("Callback has been lost because not enough free memory to hold object.");
    }

    @Override
    public void setConfig(Map config) {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
    }

    @Override
    public boolean getPurgeOnShutdown() {
        return false;
    }

    @Override
    public void purgeFiles() {
    }

    public class FailedCallback
    extends Callback {
        public FailedCallback(Object callbackPayload) {
            super(callbackPayload);
        }

        @Override
        public Object getCallbackObject() {
            throw new RuntimeException("This is an invalid callback.  The server ran out of memory, so callbacks were lost.");
        }
    }
}

