/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jboss.remoting.samples.chat.client.ChatFrame_CreateButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.ChatFrame_ExitButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.ChatFrame_ListButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.ConnectionStrategy;
import org.jboss.remoting.samples.chat.client.DummyConnectionStrategy;
import org.jboss.remoting.samples.chat.client.TalkFrame;
import org.jboss.remoting.samples.chat.exceptions.ConnectionException;

public class ChatFrame
extends CloseableFrame {
    JPanel contentPane;
    JLabel statusBar = new JLabel();
    JLabel LeChat = new JLabel();
    JButton ListButton = new JButton();
    JButton CreateButton = new JButton();
    JButton ExitButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ConnectionStrategy cs;

    public static void main(String[] args) {
        try {
            ChatFrame frame = new ChatFrame(new DummyConnectionStrategy());
            frame.setDefaultCloseOperation(3);
            frame.show();
        }
        catch (ConnectionException ce) {
            System.out.println("unable to create chat frame");
        }
    }

    public ChatFrame(ConnectionStrategy cs) {
        this.enableEvents(64L);
        this.cs = cs;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(400, 300));
        this.setTitle("Le Chat");
        this.statusBar.setText(" ");
        this.LeChat.setFont(new Font("Serif", 1, 36));
        this.LeChat.setHorizontalAlignment(0);
        this.LeChat.setHorizontalTextPosition(0);
        this.LeChat.setText("Le Chat");
        this.ListButton.setFont(new Font("SansSerif", 1, 14));
        this.ListButton.setText("List");
        this.ListButton.addActionListener(new ChatFrame_ListButton_actionAdapter(this));
        this.CreateButton.setFont(new Font("SansSerif", 1, 14));
        this.CreateButton.setText("Create");
        this.CreateButton.addActionListener(new ChatFrame_CreateButton_actionAdapter(this));
        this.ExitButton.setFont(new Font("SansSerif", 1, 14));
        this.ExitButton.setText("Exit");
        this.ExitButton.addActionListener(new ChatFrame_ExitButton_actionAdapter(this));
        this.contentPane.add((Component)this.statusBar, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(80, 0, 0, 0), 397, 0));
        this.contentPane.add((Component)this.LeChat, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(106, 80, 0, 85), 111, -10));
        this.contentPane.add((Component)this.ListButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(38, 57, 0, 0), 14, -4));
        this.contentPane.add((Component)this.ExitButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(36, 24, 0, 64), 12, -4));
        this.contentPane.add((Component)this.CreateButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(38, 24, 0, 0), 4, -4));
        this.center();
        this.pack();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    void ListButton_actionPerformed(ActionEvent e) {
        try {
            this.cs.list();
        }
        catch (ConnectionException ce) {
            System.out.println("list button catches exception:");
            System.out.println(ce);
        }
    }

    void CreateButton_actionPerformed(ActionEvent e) {
        try {
            this.cs.create();
        }
        catch (ConnectionException ce) {
            System.out.println("create button catches exception:");
            System.out.println(ce);
        }
    }

    void ExitButton_actionPerformed(ActionEvent e) {
        TalkFrame.exit();
    }
}

