/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.serialization;

import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.samples.serialization.NonSerializablePayload;
import org.jboss.remoting.transport.Connector;

public class SerializationServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private static final NonSerializablePayload RESPONSE_VALUE = new NonSerializablePayload("bar", 2);

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Starting remoting server with locator uri of: " + locatorURI);
        Connector connector = new Connector(locator);
        connector.create();
        SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
        connector.addInvocationHandler("sample", invocationHandler);
        connector.start();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 3) {
            transport = args[0];
            host = args[1];
            port = Integer.parseInt(args[2]);
        }
        String locatorURI = transport + "://" + host + ":" + port + "/?serializationtype=jboss";
        SerializationServer server = new SerializationServer();
        try {
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler {
        @Override
        public Object invoke(InvocationRequest invocation) throws Throwable {
            System.out.println("Invocation request is: " + invocation.getParameter());
            System.out.println("Returning response of: " + RESPONSE_VALUE);
            return RESPONSE_VALUE;
        }

        @Override
        public void addListener(InvokerCallbackHandler callbackHandler) {
        }

        @Override
        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        @Override
        public void setMBeanServer(MBeanServer server) {
        }

        @Override
        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

