/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.util.SecurityUtility;

public abstract class WebServerInvoker
extends ServerInvoker {
    public static String HEADER_SESSION_ID = "sessionId";
    public static String HEADER_SUBSYSTEM = "subsystem";

    public WebServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public WebServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public boolean isTransportBiDirectional() {
        return false;
    }

    protected String getDefaultDataType() {
        return "http";
    }

    protected InvocationRequest getInvocationRequest(Map metadata, Object obj) {
        InvocationRequest request = null;
        if (obj instanceof InvocationRequest) {
            request = (InvocationRequest)obj;
            if (request.getRequestPayload() == null) {
                request.setRequestPayload(metadata);
            } else {
                request.getRequestPayload().putAll(metadata);
            }
        } else {
            request = this.createNewInvocationRequest(metadata, obj);
        }
        return request;
    }

    public UnMarshaller getUnMarshaller() {
        ClassLoader classLoader = WebServerInvoker.getClassLoader(WebServerInvoker.class);
        Map map = this.passConfigMapToMarshalFactory ? this.configuration : null;
        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), classLoader, map);
        if (unmarshaller == null) {
            unmarshaller = MarshalFactory.getUnMarshaller(this.getDataType(), this.getSerializationType());
        }
        return unmarshaller;
    }

    public Marshaller getMarshaller() {
        ClassLoader classLoader = WebServerInvoker.getClassLoader(WebServerInvoker.class);
        Map map = this.passConfigMapToMarshalFactory ? this.configuration : null;
        Marshaller marshaller = MarshalFactory.getMarshaller(this.getLocator(), classLoader, map);
        if (marshaller == null) {
            marshaller = MarshalFactory.getMarshaller(this.getDataType(), this.getSerializationType());
        }
        return marshaller;
    }

    protected InvocationRequest createNewInvocationRequest(Map metadata, Object payload) {
        String sessionId = this.getSessionId(metadata);
        String subSystem = (String)metadata.get(HEADER_SUBSYSTEM);
        CreatedInvocationRequest request = null;
        HashMap responseMap = new HashMap();
        boolean isLeasQuery = this.checkForLeaseQuery(metadata);
        if (isLeasQuery) {
            this.addLeaseInfo(responseMap);
            request = new CreatedInvocationRequest(sessionId, subSystem, "$PING$", null, responseMap, null);
        } else {
            request = new CreatedInvocationRequest(sessionId, subSystem, payload, metadata, null, null);
        }
        request.setReturnPayload(responseMap);
        return request;
    }

    private boolean checkForLeaseQuery(Map headers) {
        boolean isLeaseQuery = false;
        if (headers != null) {
            Object val = headers.get("JBoss-Remoting-Lease-Query");
            if (val != null && val instanceof String) {
                isLeaseQuery = Boolean.valueOf((String)val);
            } else {
                val = headers.get("jboss-remoting-lease-query");
                if (val != null && val instanceof String) {
                    isLeaseQuery = Boolean.valueOf((String)val);
                }
            }
        }
        return isLeaseQuery;
    }

    private void addLeaseInfo(Map response) {
        boolean leaseManagement = this.isLeaseActivated();
        response.put("LEASING_ENABLED", new Boolean(leaseManagement));
        if (leaseManagement) {
            long leasePeriod = this.getLeasePeriod();
            response.put("LEASE_PERIOD", new Long(leasePeriod));
        }
    }

    protected String getSessionId(Map metadata) {
        String sessionId = (String)metadata.get(HEADER_SESSION_ID);
        if (sessionId == null || sessionId.length() == 0) {
            String userAgent = (String)metadata.get("User-Agent");
            String host = (String)metadata.get("Host");
            String idSeed = userAgent + ":" + host;
            sessionId = Integer.toString(idSeed.hashCode());
        }
        return sessionId;
    }

    protected int getContentLength(Object response) throws IOException {
        if (response != null) {
            if (response instanceof String) {
                return ((String)response).length();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(response);
            oos.flush();
            bos.flush();
            byte[] buffer = bos.toByteArray();
            return buffer.length;
        }
        return 0;
    }

    private static ClassLoader getClassLoader(final Class c) {
        if (SecurityUtility.skipAccessControl()) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    protected static class CreatedInvocationRequest
    extends InvocationRequest {
        public CreatedInvocationRequest(String sessionId, String subsystem, Object arg, Map requestPayload, Map returnPayload, InvokerLocator locator) {
            super(sessionId, subsystem, arg, requestPayload, returnPayload, locator);
        }
    }
}

