/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.LinkedList;
import java.util.Queue;
import org.jboss.xnio.CloseableExecutor;
import org.jboss.xnio.log.Logger;

final class QueueExecutor
implements CloseableExecutor {
    private static final Logger log = Logger.getLogger(QueueExecutor.class);
    private final Queue<Runnable> queue = new LinkedList<Runnable>();
    private State state = State.WAITING;

    QueueExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) {
        Queue<Runnable> queue = this.queue;
        synchronized (queue) {
            switch (this.state) {
                case WAITING: {
                    this.state = State.RUNNING;
                    this.queue.notify();
                }
                case STOPPING: 
                case RUNNING: {
                    this.queue.add(command);
                    break;
                }
                default: {
                    throw new IllegalStateException("Executor is no longer available");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runQueue() {
        boolean intr = Thread.interrupted();
        try {
            Queue<Runnable> queue;
            block14: while (true) {
                State newState;
                queue = this.queue;
                synchronized (queue) {
                    while (this.state == State.WAITING) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                    if (this.state == State.DOWN) {
                        throw new IllegalStateException("DOWN");
                    }
                    newState = this.state;
                }
                while (true) {
                    Runnable runnable;
                    Queue<Runnable> e = this.queue;
                    synchronized (e) {
                        runnable = this.queue.poll();
                        if (runnable == null) {
                            // MONITOREXIT @DISABLED, blocks:[0, 16, 18, 8, 14] lbl22 : MonitorExitStatement: MONITOREXIT : e
                            if (newState != State.STOPPING) continue block14;
                            break block14;
                        }
                    }
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        log.trace(t, "Error occurred while processing run queue", new Object[0]);
                    }
                }
                break;
            }
            queue = this.queue;
            synchronized (queue) {
                this.state = State.DOWN;
                return;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Queue<Runnable> queue = this.queue;
        synchronized (queue) {
            switch (this.state) {
                case WAITING: {
                    this.queue.notify();
                }
                case RUNNING: {
                    this.state = State.STOPPING;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        WAITING,
        STOPPING,
        DOWN;

    }
}

