/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.remote.AbstractClientMessageHandler;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteMessageHandler;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Result;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientAuthenticationHandler
extends AbstractClientMessageHandler {
    private final RemoteConnection remoteConnection;
    private final SaslClient saslClient;
    private final Result<ConnectionHandlerFactory> factoryResult;
    private static final Logger log = Loggers.clientSasl;

    ClientAuthenticationHandler(RemoteConnection remoteConnection, SaslClient saslClient, Result<ConnectionHandlerFactory> factoryResult) {
        super(remoteConnection, factoryResult);
        this.remoteConnection = remoteConnection;
        this.saslClient = saslClient;
        this.factoryResult = factoryResult;
    }

    public void handleMessage(ByteBuffer buffer) {
        byte msgType = buffer.get();
        switch (msgType) {
            case 2: {
                byte[] response;
                log.trace("Received challenge message");
                boolean clientComplete = this.saslClient.isComplete();
                if (clientComplete) {
                    log.trace("Received extra auth challenge message on %s after completion", (Object)this.remoteConnection);
                    this.factoryResult.setException((IOException)new SaslException("Received extra auth message after completion"));
                    IoUtils.safeClose((Closeable)this.remoteConnection);
                    return;
                }
                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                try {
                    response = this.saslClient.evaluateChallenge(challenge);
                    if (msgType == 4 && response != null && response.length > 0) {
                        log.trace("Received extra auth message on %s", (Object)this.remoteConnection);
                        this.factoryResult.setException((IOException)new SaslException("Received extra auth message after completion"));
                        IoUtils.safeClose((Closeable)this.remoteConnection);
                        return;
                    }
                }
                catch (SaslException e) {
                    log.trace((Throwable)e, "Authentication error", new Object[0]);
                    this.factoryResult.setException((IOException)e);
                    try {
                        this.remoteConnection.shutdownWritesBlocking();
                    }
                    catch (IOException e1) {
                        log.trace((Throwable)e, "Unable to shut down writes", new Object[0]);
                    }
                    return;
                }
                try {
                    log.trace("Sending SASL response");
                    this.remoteConnection.sendAuthMessage((byte)3, response);
                }
                catch (IOException e) {
                    this.factoryResult.setException(e);
                    log.trace("Failed to send auth response message on %s", (Object)this.remoteConnection);
                    IoUtils.safeClose((Closeable)this.remoteConnection);
                    return;
                }
                return;
            }
            case 4: {
                log.trace("Received auth complete message");
                boolean clientComplete = this.saslClient.isComplete();
                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                if (!clientComplete) {
                    try {
                        byte[] response = this.saslClient.evaluateChallenge(challenge);
                        if (response != null && response.length > 0) {
                            log.trace("Received extra auth message on %s", (Object)this.remoteConnection);
                            this.factoryResult.setException((IOException)new SaslException("Received extra auth message after completion"));
                            IoUtils.safeClose((Closeable)this.remoteConnection);
                            return;
                        }
                        if (!this.saslClient.isComplete()) {
                            log.trace("Client not complete after processing auth complete message on %s", (Object)this.remoteConnection);
                            this.factoryResult.setException((IOException)new SaslException("Client not complete after processing auth complete message"));
                            IoUtils.safeClose((Closeable)this.remoteConnection);
                            return;
                        }
                    }
                    catch (SaslException e) {
                        log.trace((Throwable)e, "Authentication error", new Object[0]);
                        this.factoryResult.setException((IOException)e);
                        try {
                            this.remoteConnection.shutdownWritesBlocking();
                        }
                        catch (IOException e1) {
                            log.trace((Throwable)e, "Unable to shut down writes", new Object[0]);
                        }
                        return;
                    }
                }
                this.factoryResult.setResult((Object)new ConnectionHandlerFactory(){

                    public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                        MarshallerFactory marshallerFactory = ClientAuthenticationHandler.this.remoteConnection.getProviderDescriptor().getMarshallerFactory();
                        RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientAuthenticationHandler.this.remoteConnection, marshallerFactory);
                        ClientAuthenticationHandler.this.remoteConnection.addCloseHandler(SpiUtils.closingCloseHandler(connectionHandler));
                        ClientAuthenticationHandler.this.remoteConnection.setMessageHandler(new RemoteMessageHandler(connectionHandler, ClientAuthenticationHandler.this.remoteConnection));
                        return connectionHandler;
                    }
                });
                return;
            }
            case 5: {
                log.trace("Received auth rejected message");
                this.factoryResult.setException((IOException)new SaslException("Authentication failed"));
                IoUtils.safeClose((Closeable)this.remoteConnection);
            }
        }
    }
}

