/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jboss.remoting3.remote.OutboundStream;
import org.jboss.xnio.IoUtils;

final class OutboundInputStreamTransmitTask
implements Runnable {
    private final InputStream inputStream;
    private final OutboundStream outboundStream;

    OutboundInputStreamTransmitTask(InputStream inputStream, OutboundStream outboundStream) {
        this.inputStream = inputStream;
        this.outboundStream = outboundStream;
    }

    public void run() {
        InputStream inputStream = this.inputStream;
        try {
            OutboundStream outboundStream = this.outboundStream;
            byte[] bytes = new byte[1024];
            while (true) {
                int res = 0;
                try {
                }
                catch (IOException e) {
                    outboundStream.sendException();
                    IoUtils.safeClose((Closeable)inputStream);
                    return;
                }
                if (res == -1) {
                    outboundStream.sendEof();
                    return;
                }
                try {
                    int xsz;
                    for (res = inputStream.read(bytes); res > 0; res -= xsz) {
                        ByteBuffer buffer = outboundStream.getBuffer();
                        xsz = Math.min(buffer.remaining(), res);
                        buffer.put(bytes, 0, xsz).flip();
                        outboundStream.send(buffer);
                    }
                }
                catch (IOException e) {
                    outboundStream.sendEof();
                    IoUtils.safeClose((Closeable)inputStream);
                    return;
                }
            }
        }
        finally {
            IoUtils.safeClose((Closeable)inputStream);
        }
    }
}

