/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.remoting3.stream.ObjectSink;
import org.jboss.remoting3.stream.ObjectSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectPipe<T> {
    private final Lock queueLock = new ReentrantLock();
    private final Condition writeCondition = this.queueLock.newCondition();
    private final Condition readCondition = this.queueLock.newCondition();
    private final Queue<T> queue;
    private final Source source = new Source();
    private final Sink sink = new Sink();
    private final int max;
    private boolean open = true;

    public ObjectPipe(int max) {
        this.max = max;
        this.queue = new ArrayDeque<T>(max);
    }

    public ObjectSource<T> getSource() {
        return this.source;
    }

    public ObjectSink<T> getSink() {
        return this.sink;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Sink
    implements ObjectSink<T> {
        private Sink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T instance) throws IOException {
            int max = ObjectPipe.this.max;
            Queue queue = ObjectPipe.this.queue;
            Lock queueLock = ObjectPipe.this.queueLock;
            try {
                queueLock.lockInterruptibly();
                try {
                    while (ObjectPipe.this.open && queue.size() == max) {
                        ObjectPipe.this.readCondition.await();
                    }
                    if (!ObjectPipe.this.open) {
                        throw new EOFException("pipe closed");
                    }
                }
                finally {
                    queueLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("accept(T) was interrupted");
            }
        }

        @Override
        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Lock queueLock = ObjectPipe.this.queueLock;
            queueLock.lock();
            try {
                if (!ObjectPipe.this.open) {
                    return;
                }
                ObjectPipe.this.open = false;
                if (ObjectPipe.this.queue.isEmpty()) {
                    ObjectPipe.this.readCondition.signalAll();
                } else {
                    ObjectPipe.this.readCondition.signal();
                }
                ObjectPipe.this.writeCondition.signalAll();
            }
            finally {
                queueLock.unlock();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Source
    implements ObjectSource<T> {
        private Source() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() throws IOException {
            Lock queueLock = ObjectPipe.this.queueLock;
            Condition writeCondition = ObjectPipe.this.writeCondition;
            Queue queue = ObjectPipe.this.queue;
            queueLock.lockInterruptibly();
            try {
                while (ObjectPipe.this.open && queue.isEmpty()) {
                    writeCondition.await();
                }
                boolean bl = ObjectPipe.this.open || !queue.isEmpty();
                queueLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    queueLock.unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("hasNext() was interrupted");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T next() throws IOException {
            Lock queueLock = ObjectPipe.this.queueLock;
            Queue queue = ObjectPipe.this.queue;
            try {
                queueLock.lockInterruptibly();
                try {
                    Object t = queue.poll();
                    if (t == null) {
                        if (!ObjectPipe.this.open) throw new EOFException("EOF on next()");
                        throw new NoSuchElementException();
                    }
                    ObjectPipe.this.readCondition.signal();
                    Object e = t;
                    return e;
                }
                finally {
                    queueLock.unlock();
                }
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("hasNext() was interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Lock queueLock = ObjectPipe.this.queueLock;
            queueLock.lock();
            try {
                if (ObjectPipe.this.open) {
                    ObjectPipe.this.open = false;
                    ObjectPipe.this.queue.clear();
                    ObjectPipe.this.writeCondition.signalAll();
                    ObjectPipe.this.readCondition.signalAll();
                }
            }
            finally {
                queueLock.unlock();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

