/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.LoopbackChannel;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Cancellable;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Result;

final class LocalConnectionProvider
extends AbstractHandleableCloseable<ConnectionProvider>
implements ConnectionProvider {
    private final Executor executor;
    private final ConnectionProviderContext context;

    LocalConnectionProvider(ConnectionProviderContext context, Executor executor) {
        super(executor);
        this.context = context;
        this.executor = executor;
    }

    @Override
    public Cancellable connect(URI uri, OptionMap connectOptions, Result<ConnectionHandlerFactory> result, CallbackHandler callbackHandler) throws IllegalArgumentException {
        this.context.accept(new ConnectionHandlerFactory(){

            @Override
            public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                return new LoopbackConnectionHandler(connectionContext);
            }
        });
        return IoUtils.nullCancellable();
    }

    @Override
    public Object getProviderInterface() {
        return NO_PROVIDER_INTERFACES;
    }

    private class LoopbackConnectionHandler
    extends AbstractHandleableCloseable<ConnectionHandler>
    implements ConnectionHandler {
        private final ConnectionHandlerContext context;

        LoopbackConnectionHandler(ConnectionHandlerContext context) {
            super(LocalConnectionProvider.this.executor);
            this.context = context;
        }

        @Override
        public Cancellable open(String serviceType, Result<Channel> result, OptionMap optionMap) {
            LoopbackChannel channel = new LoopbackChannel(LocalConnectionProvider.this.executor);
            try {
                this.context.openService(channel.getOtherSide(), serviceType);
            }
            catch (ServiceNotFoundException e) {
                result.setException((IOException)e);
                return IoUtils.nullCancellable();
            }
            result.setResult((Object)channel);
            return IoUtils.nullCancellable();
        }

        @Override
        public Collection<Principal> getPrincipals() {
            return Collections.emptySet();
        }
    }
}

