/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.remote.ExternalSaslServerFactory;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteAuthLogger;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslUtils;

final class ServerConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final ServerAuthenticationProvider serverAuthenticationProvider;
    private final OptionMap optionMap;
    private final AtomicInteger retryCount = new AtomicInteger(8);
    private final String serverName;

    ServerConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, ServerAuthenticationProvider serverAuthenticationProvider, OptionMap optionMap) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        this.optionMap = optionMap;
        this.serverName = ((InetSocketAddress)connection.getChannel().getLocalAddress(InetSocketAddress.class)).getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ConnectedMessageChannel channel) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
            sendBuffer.put((byte)0);
            ProtocolUtils.writeString(sendBuffer, (byte)0, this.serverName);
            sendBuffer.flip();
            this.connection.setReadListener(new Initial());
            this.connection.send(pooled);
            ok = true;
            return;
        }
        catch (BufferUnderflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        catch (BufferOverflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslServer saslServer;

        Authentication(SaslServer saslServer) {
            this.saslServer = saslServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledBuffer = ServerConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                final ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ServerConnectionOpenListener.this.connection.handleException(e);
                    pooledBuffer.free();
                    return;
                }
                if (res == -1) {
                    RemoteLogger.log.trace("Received connection end-of-stream");
                    ServerConnectionOpenListener.this.connection.handleIncomingCloseRequest();
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.server.tracef("Received %s", buffer);
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handleIncomingCloseRequest();
                        return;
                    }
                    case 4: {
                        RemoteLogger.server.tracef("Server received authentication response", new Object[0]);
                        ServerConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                boolean ok = false;
                                boolean close = false;
                                Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                                try {
                                    ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                    int p = sendBuffer.position();
                                    try {
                                        sendBuffer.put((byte)5);
                                        if (SaslUtils.evaluateResponse((SaslServer)Authentication.this.saslServer, (ByteBuffer)sendBuffer, (ByteBuffer)buffer)) {
                                            RemoteLogger.server.tracef("Server sending authentication complete", new Object[0]);
                                            ServerConnectionOpenListener.this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                                                @Override
                                                public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                                    RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerConnectionOpenListener.this.connection);
                                                    ServerConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ServerConnectionOpenListener.this.connection));
                                                    return connectionHandler;
                                                }
                                            });
                                        } else {
                                            RemoteLogger.server.tracef("Server sending authentication challenge", new Object[0]);
                                            sendBuffer.put(p, (byte)3);
                                        }
                                    }
                                    catch (SaslException e) {
                                        RemoteLogger.server.tracef("Server sending authentication rejected (%s)", e);
                                        sendBuffer.put(p, (byte)6);
                                        ServerConnectionOpenListener.this.connection.setReadListener(new Initial());
                                    }
                                    sendBuffer.flip();
                                    ServerConnectionOpenListener.this.connection.send(pooled, close);
                                    ServerConnectionOpenListener.this.connection.getChannel().resumeReads();
                                    ok = true;
                                    return;
                                }
                                finally {
                                    if (!ok) {
                                        pooled.free();
                                    }
                                }
                            }
                        });
                        ServerConnectionOpenListener.this.connection.getChannel().suspendReads();
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request (cancelling authentication)");
                        Initial initial = new Initial();
                        ServerConnectionOpenListener.this.connection.setReadListener(initial);
                        initial.sendCapabilities();
                        return;
                    }
                }
                RemoteLogger.server.unknownProtocolId(msgType);
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
            }
            catch (BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledBuffer.free();
            }
        }
    }

    final class Initial
    implements ChannelListener<ConnectedMessageChannel> {
        private final int version;
        private final boolean starttls;
        private final Map<String, ?> propertyMap;
        private final Map<String, SaslServerFactory> allowedMechanisms;

        Initial() {
            this.version = 0;
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            boolean channelSecure = Channels.getOption((Configurable)ServerConnectionOpenListener.this.connection.getChannel(), (Option)Options.SECURE, (boolean)false);
            this.starttls = sslChannel != null && !channelSecure;
            LinkedHashMap<String, SaslServerFactory> allowedMechanisms = new LinkedHashMap<String, SaslServerFactory>();
            Map propertyMap = SaslUtils.createPropertyMap((OptionMap)ServerConnectionOpenListener.this.optionMap, (boolean)channelSecure);
            Sequence saslMechs = (Sequence)ServerConnectionOpenListener.this.optionMap.get(Options.SASL_MECHANISMS);
            HashSet restrictions = saslMechs == null ? null : new HashSet(saslMechs);
            Sequence saslNoMechs = (Sequence)ServerConnectionOpenListener.this.optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
            HashSet disallowed = saslNoMechs == null ? Collections.emptySet() : new HashSet(saslNoMechs);
            Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
            try {
                if ((restrictions == null || restrictions.contains("EXTERNAL")) && !disallowed.contains("EXTERNAL")) {
                    if (sslChannel != null) {
                        Principal principal = sslChannel.getSslSession().getPeerPrincipal();
                        if (principal != null) {
                            allowedMechanisms.put("EXTERNAL", new ExternalSaslServerFactory(principal));
                        } else {
                            RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of peer principal");
                        }
                    } else {
                        RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of SSL");
                    }
                } else {
                    RemoteLogger.server.trace("No EXTERNAL mechanism due to explicit exclusion");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            while (factories.hasMoreElements()) {
                SaslServerFactory factory = factories.nextElement();
                RemoteLogger.server.tracef("Trying SASL server factory %s", factory);
                for (String mechName : factory.getMechanismNames(propertyMap)) {
                    if (restrictions != null && !restrictions.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is not in the allowed list", mechName);
                        continue;
                    }
                    if (disallowed.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is in the disallowed list", mechName);
                        continue;
                    }
                    if (allowedMechanisms.containsKey(mechName)) {
                        RemoteLogger.server.tracef("Excluding repeated occurrence of mechanism %s", mechName);
                        continue;
                    }
                    RemoteLogger.server.tracef("Added mechanism %s", mechName);
                    allowedMechanisms.put(mechName, factory);
                }
            }
            this.propertyMap = propertyMap;
            this.allowedMechanisms = allowedMechanisms;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            byte msgType;
            Pooled<ByteBuffer> pooledBuffer;
            block49: {
                SaslServer saslServer;
                ByteBuffer buffer;
                block48: {
                    pooledBuffer = ServerConnectionOpenListener.this.connection.allocate();
                    try {
                        int res;
                        buffer = (ByteBuffer)pooledBuffer.getResource();
                        try {
                            res = channel.receive(buffer);
                        }
                        catch (IOException e) {
                            ServerConnectionOpenListener.this.connection.handleException(e);
                            pooledBuffer.free();
                            return;
                        }
                        if (res == 0) {
                            return;
                        }
                        if (res == -1) {
                            RemoteLogger.log.trace("Received connection end-of-stream");
                            ServerConnectionOpenListener.this.connection.handleIncomingCloseRequest();
                            return;
                        }
                        buffer.flip();
                        msgType = buffer.get();
                        switch (msgType) {
                            case -1: {
                                RemoteLogger.server.trace("Server received connection close request");
                                ServerConnectionOpenListener.this.connection.handleIncomingCloseRequest();
                                return;
                            }
                            case -16: {
                                RemoteLogger.server.trace("Server received connection alive");
                                return;
                            }
                            case 1: {
                                RemoteLogger.server.trace("Server received capabilities request");
                                this.sendCapabilities();
                                return;
                            }
                            case 7: {
                                RemoteLogger.server.tracef("Server received STARTTLS request", new Object[0]);
                                Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                                boolean ok = false;
                                try {
                                    ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                    sendBuffer.put(this.starttls ? (byte)7 : 8);
                                    sendBuffer.flip();
                                    ServerConnectionOpenListener.this.connection.send(pooled);
                                    if (this.starttls) {
                                        try {
                                            ServerConnectionOpenListener.this.connection.getSslChannel().startHandshake();
                                        }
                                        catch (IOException e) {
                                            ServerConnectionOpenListener.this.connection.handleException(e);
                                        }
                                    }
                                    ok = true;
                                    return;
                                }
                                finally {
                                    if (!ok) {
                                        pooled.free();
                                    }
                                }
                            }
                            case 2: {
                                break block48;
                            }
                        }
                        break block49;
                    }
                    catch (BufferUnderflowException e) {
                        ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                        return;
                    }
                    catch (BufferOverflowException e) {
                        ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                        return;
                    }
                }
                RemoteLogger.server.tracef("Server received authentication request", new Object[0]);
                if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() < 1) {
                    ServerConnectionOpenListener.this.connection.handleException(new SaslException("Too many authentication failures; connection terminated"), false);
                    return;
                }
                String mechName = Buffers.getModifiedUtf8((ByteBuffer)buffer);
                SaslServerFactory saslServerFactory = this.allowedMechanisms.get(mechName);
                CallbackHandler callbackHandler = ServerConnectionOpenListener.this.serverAuthenticationProvider.getCallbackHandler(mechName);
                if (saslServerFactory == null || callbackHandler == null) {
                    RemoteAuthLogger.authLog.rejectedInvalidMechanism(mechName);
                    Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                    ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                    sendBuffer.put((byte)6);
                    sendBuffer.flip();
                    ServerConnectionOpenListener.this.connection.send(pooled);
                    return;
                }
                try {
                    saslServer = saslServerFactory.createSaslServer(mechName, "remote", ServerConnectionOpenListener.this.serverName, this.propertyMap, callbackHandler);
                }
                catch (SaslException e) {
                    ServerConnectionOpenListener.this.connection.handleException(e);
                    pooledBuffer.free();
                    return;
                }
                boolean ok = false;
                boolean close = false;
                Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                try {
                    ByteBuffer sendBuffer;
                    block50: {
                        sendBuffer = (ByteBuffer)pooled.getResource();
                        int p = sendBuffer.position();
                        try {
                            sendBuffer.put((byte)5);
                            if (SaslUtils.evaluateResponse((SaslServer)saslServer, (ByteBuffer)sendBuffer, (ByteBuffer)buffer)) {
                                RemoteLogger.server.tracef("Server sending authentication complete", new Object[0]);
                                ServerConnectionOpenListener.this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                                    @Override
                                    public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                        RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerConnectionOpenListener.this.connection);
                                        ServerConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ServerConnectionOpenListener.this.connection));
                                        return connectionHandler;
                                    }
                                });
                            } else {
                                RemoteLogger.server.tracef("Server sending authentication challenge", new Object[0]);
                                sendBuffer.put(p, (byte)3);
                                ServerConnectionOpenListener.this.connection.setReadListener(new Authentication(saslServer));
                            }
                        }
                        catch (Exception e) {
                            RemoteLogger.server.tracef("Server sending authentication rejected (%s)", e);
                            sendBuffer.put(p, (byte)6);
                            if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() > 0) break block50;
                            close = true;
                        }
                    }
                    sendBuffer.flip();
                    ServerConnectionOpenListener.this.connection.send(pooled, close);
                    ok = true;
                    return;
                }
                finally {
                    if (!ok) {
                        pooled.free();
                    }
                }
            }
            RemoteLogger.server.unknownProtocolId(msgType);
            ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
            return;
            finally {
                pooledBuffer.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendCapabilities() {
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)1);
                ProtocolUtils.writeByte(sendBuffer, 0, this.version);
                if (this.starttls) {
                    ProtocolUtils.writeEmpty(sendBuffer, 2);
                }
                for (String mechName : this.allowedMechanisms.keySet()) {
                    ProtocolUtils.writeString(sendBuffer, (byte)1, mechName);
                }
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
                return;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }
    }
}

