/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.ClientConnectionOpenListener;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.ServerConnectionOpenListener;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelThreadPool;
import org.xnio.ConnectionChannelThread;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.ReadChannelThread;
import org.xnio.Result;
import org.xnio.WriteChannelThread;
import org.xnio.Xnio;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.FramedMessageChannel;
import org.xnio.ssl.XnioSsl;

final class RemoteConnectionProvider
extends AbstractHandleableCloseable<ConnectionProvider>
implements ConnectionProvider {
    private final ProviderInterface providerInterface = new ProviderInterface();
    private final Xnio xnio;
    private final XnioSsl xnioSsl;
    private final ChannelThreadPool<ReadChannelThread> readThreadPool;
    private final ChannelThreadPool<WriteChannelThread> writeThreadPool;
    private final ConnectionProviderContext connectionProviderContext;
    private final Pool<ByteBuffer> messageBufferPool;
    private final Pool<ByteBuffer> framingBufferPool;

    RemoteConnectionProvider(OptionMap optionMap, ConnectionProviderContext connectionProviderContext) throws IOException {
        super(connectionProviderContext.getExecutor());
        this.xnio = connectionProviderContext.getXnio();
        try {
            this.xnioSsl = optionMap.get(Options.SSL_ENABLED, true) ? this.xnio.getSslProvider(optionMap) : null;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to configure SSL", e);
        }
        this.readThreadPool = connectionProviderContext.getReadThreadPool();
        this.writeThreadPool = connectionProviderContext.getWriteThreadPool();
        this.connectionProviderContext = connectionProviderContext;
        int messageBufferSize = optionMap.get(RemotingOptions.RECEIVE_BUFFER_SIZE, 8192);
        this.messageBufferPool = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, messageBufferSize, optionMap.get(RemotingOptions.BUFFER_REGION_SIZE, messageBufferSize * 2));
        int framingBufferSize = messageBufferSize + 4;
        this.framingBufferPool = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, framingBufferSize, optionMap.get(RemotingOptions.BUFFER_REGION_SIZE, framingBufferSize * 2));
    }

    @Override
    public Cancellable connect(URI uri, final OptionMap connectOptions, final Result<ConnectionHandlerFactory> result, final CallbackHandler callbackHandler) throws IllegalArgumentException {
        InetSocketAddress destination;
        if (!this.isOpen()) {
            throw new IllegalStateException("Connection provider is closed");
        }
        RemoteLogger.log.tracef("Attempting to connect to \"%s\" with options %s", uri, connectOptions);
        boolean sslCapable = this.xnioSsl != null;
        boolean useSsl = sslCapable && !connectOptions.get(Options.SECURE, false);
        try {
            destination = new InetSocketAddress(InetAddress.getByName(uri.getHost()), uri.getPort());
        }
        catch (UnknownHostException e) {
            result.setException((IOException)e);
            return IoUtils.nullCancellable();
        }
        ChannelListener<ConnectedStreamChannel> openListener = new ChannelListener<ConnectedStreamChannel>(){

            public void handleEvent(ConnectedStreamChannel channel) {
                try {
                    channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
                }
                catch (IOException e) {
                    // empty catch block
                }
                FramedMessageChannel messageChannel = new FramedMessageChannel(channel, RemoteConnectionProvider.this.framingBufferPool.allocate(), RemoteConnectionProvider.this.framingBufferPool.allocate());
                RemoteConnection remoteConnection = new RemoteConnection((Pool<ByteBuffer>)RemoteConnectionProvider.this.messageBufferPool, channel, (ConnectedMessageChannel)messageChannel, connectOptions, RemoteConnectionProvider.this.getExecutor());
                remoteConnection.setResult((Result<ConnectionHandlerFactory>)result);
                messageChannel.getWriteSetter().set(remoteConnection.getWriteListener());
                ClientConnectionOpenListener openListener = new ClientConnectionOpenListener(remoteConnection, RemoteConnectionProvider.this.connectionProviderContext, callbackHandler, AccessController.getContext(), connectOptions);
                openListener.handleEvent((ConnectedMessageChannel)messageChannel);
            }
        };
        WriteChannelThread writeThread = (WriteChannelThread)this.writeThreadPool.getThread();
        ReadChannelThread readThread = (ReadChannelThread)this.readThreadPool.getThread();
        IoFuture future = useSsl ? this.xnioSsl.connectSsl(destination, (ConnectionChannelThread)writeThread, readThread, writeThread, (ChannelListener)openListener, connectOptions) : this.xnio.connectStream((SocketAddress)destination, (ConnectionChannelThread)writeThread, readThread, writeThread, (ChannelListener)openListener, connectOptions);
        future.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<ConnectedStreamChannel, Result<ConnectionHandlerFactory>>(){

            public void handleCancelled(Result<ConnectionHandlerFactory> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, Result<ConnectionHandlerFactory> attachment) {
                attachment.setException(exception);
            }
        }, result);
        return future;
    }

    @Override
    public Object getProviderInterface() {
        return this.providerInterface;
    }

    @Override
    protected void closeAction() {
        this.closeComplete();
    }

    public String toString() {
        return String.format("Remoting remote connection provider %x for %s", this.hashCode(), this.connectionProviderContext.getEndpoint());
    }

    private final class AcceptListener
    implements ChannelListener<AcceptingChannel<? extends ConnectedStreamChannel>> {
        private final OptionMap serverOptionMap;
        private final ServerAuthenticationProvider serverAuthenticationProvider;
        private final AccessControlContext accessControlContext;

        AcceptListener(OptionMap serverOptionMap, ServerAuthenticationProvider serverAuthenticationProvider, AccessControlContext accessControlContext) {
            this.serverOptionMap = serverOptionMap;
            this.serverAuthenticationProvider = serverAuthenticationProvider;
            this.accessControlContext = accessControlContext;
        }

        public void handleEvent(AcceptingChannel<? extends ConnectedStreamChannel> channel) {
            ConnectedStreamChannel accepted;
            try {
                accepted = (ConnectedStreamChannel)channel.accept((ReadChannelThread)RemoteConnectionProvider.this.readThreadPool.getThread(), (WriteChannelThread)RemoteConnectionProvider.this.writeThreadPool.getThread());
                if (accepted == null) {
                    return;
                }
            }
            catch (IOException e) {
                RemoteLogger.log.failedToAccept(e);
                return;
            }
            try {
                accepted.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
            }
            catch (IOException e) {
                // empty catch block
            }
            FramedMessageChannel messageChannel = new FramedMessageChannel(accepted, RemoteConnectionProvider.this.framingBufferPool.allocate(), RemoteConnectionProvider.this.framingBufferPool.allocate());
            RemoteConnection connection = new RemoteConnection((Pool<ByteBuffer>)RemoteConnectionProvider.this.messageBufferPool, accepted, (ConnectedMessageChannel)messageChannel, this.serverOptionMap, RemoteConnectionProvider.this.getExecutor());
            ServerConnectionOpenListener openListener = new ServerConnectionOpenListener(connection, RemoteConnectionProvider.this.connectionProviderContext, this.serverAuthenticationProvider, this.serverOptionMap, this.accessControlContext);
            messageChannel.getWriteSetter().set(connection.getWriteListener());
            RemoteLogger.log.tracef("Accepted connection from %s to %s", accepted.getPeerAddress(), accepted.getLocalAddress());
            openListener.handleEvent((ConnectedMessageChannel)messageChannel);
        }
    }

    final class ProviderInterface
    implements NetworkServerProvider {
        ProviderInterface() {
        }

        @Override
        public AcceptingChannel<? extends ConnectedStreamChannel> createServer(SocketAddress bindAddress, OptionMap optionMap, ServerAuthenticationProvider authenticationProvider) throws IOException {
            AccessControlContext accessControlContext = AccessController.getContext();
            boolean sslCapable = RemoteConnectionProvider.this.xnioSsl != null;
            WriteChannelThread writeThread = (WriteChannelThread)RemoteConnectionProvider.this.writeThreadPool.getThread();
            AcceptListener acceptListener = new AcceptListener(optionMap, authenticationProvider, accessControlContext);
            final AcceptingChannel result = sslCapable && optionMap.get(Options.SSL_ENABLED, true) ? RemoteConnectionProvider.this.xnioSsl.createSslTcpServer((InetSocketAddress)bindAddress, (ConnectionChannelThread)writeThread, (ChannelListener)acceptListener, optionMap) : RemoteConnectionProvider.this.xnio.createStreamServer(bindAddress, (ConnectionChannelThread)writeThread, (ChannelListener)acceptListener, optionMap);
            RemoteConnectionProvider.this.addCloseHandler(new CloseHandler<ConnectionProvider>(){

                @Override
                public void handleClose(ConnectionProvider closed, IOException exception) {
                    IoUtils.safeClose((Closeable)result);
                }
            });
            return result;
        }
    }
}

