/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.jboss.remoting3.remote.Protocol;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.spi.SpiUtils;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Pooled;
import org.xnio.channels.ConnectedMessageChannel;

final class RemoteReadListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnectionHandler handler;
    private final RemoteConnection connection;

    RemoteReadListener(final RemoteConnectionHandler handler, final RemoteConnection connection) {
        connection.getChannel().getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                connection.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        handler.handleConnectionClose();
                    }
                });
            }
        });
        this.handler = handler;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleEvent(ConnectedMessageChannel channel) {
        try {
            pooled = this.connection.allocate();
            buffer = (ByteBuffer)pooled.getResource();
            ** try [egrp 1[TRYBLOCK] [21 : 19->77)] { 
lbl5:
            // 1 sources

            ** GOTO lbl-1000
lbl6:
            // 1 sources

            finally {
                pooled.free();
            }
        }
        catch (IOException e) {
            this.connection.handleException(e);
            return;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                try {
                    block55: while (true) {
                        if ((res = channel.receive(buffer)) == -1) {
                            RemoteLogger.log.trace("Received connection end-of-stream");
                            try {
                                channel.shutdownReads();
                                return;
                            }
                            finally {
                                this.handler.handleConnectionClose();
                            }
                        }
                        if (res == 0) {
                            return;
                        }
                        buffer.flip();
                        protoId = buffer.get();
                        try {
                            switch (protoId) {
                                case -16: {
                                    break;
                                }
                                case -1: {
                                    RemoteLogger.log.trace("Received connection close request");
                                    this.handler.receiveCloseRequest();
                                    return;
                                }
                                case 16: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    inboundWindow = 16384;
                                    inboundMessages = 80;
                                    outboundWindow = 16384;
                                    outboundMessages = 80;
                                    serviceType = null;
                                    block56: while (true) {
                                        b = buffer.get() & 255;
                                        switch (b) {
                                            case 0: {
                                                break block56;
                                            }
                                            case 1: {
                                                serviceType = ProtocolUtils.readString(buffer);
                                                continue block56;
                                            }
                                            case 128: {
                                                outboundWindow = ProtocolUtils.readInt(buffer);
                                                continue block56;
                                            }
                                            case 129: {
                                                outboundMessages = ProtocolUtils.readUnsignedShort(buffer);
                                                continue block56;
                                            }
                                            default: {
                                                Buffers.skip((Buffer)buffer, (int)(buffer.get() & 255));
                                                continue block56;
                                            }
                                        }
                                        break;
                                    }
                                    if ((channelId & -2147483648) != 0) {
                                        this.refuseService(channelId, "Invalid channel ID");
                                        break;
                                    }
                                    if (serviceType == null) {
                                        this.refuseService(channelId, "Missing service name");
                                        break;
                                    }
                                    openListener = this.handler.getConnectionContext().getServiceOpenListener(serviceType);
                                    if (openListener == null) {
                                        this.refuseService(channelId, "Unknown service name");
                                        break;
                                    }
                                    if (!this.handler.handleInboundChannelOpen()) {
                                        this.refuseService(channelId, "Channel refused");
                                        break;
                                    }
                                    ok1 = false;
                                    try {
                                        connectionChannel = new RemoteConnectionChannel(this.handler, this.connection, channelId, outboundWindow, inboundWindow, outboundMessages, inboundMessages);
                                        existing = this.handler.addChannel(connectionChannel);
                                        if (existing != null) {
                                            RemoteLogger.log.tracef("Encountered open request for duplicate %s", existing);
                                            try {
                                                this.refuseService(channelId, "Duplicate ID");
                                                continue block55;
                                            }
                                            finally {
                                                existing.handleRemoteClose();
                                                continue block55;
                                            }
                                        }
                                        pooledReply = this.connection.allocate();
                                        ok2 = false;
                                        try {
                                            replyBuffer = (ByteBuffer)pooledReply.getResource();
                                            replyBuffer.clear();
                                            replyBuffer.put((byte)17);
                                            replyBuffer.putInt(channelId);
                                            ProtocolUtils.writeInt(replyBuffer, 128, outboundWindow);
                                            ProtocolUtils.writeShort(replyBuffer, 129, outboundMessages);
                                            replyBuffer.put((byte)0);
                                            replyBuffer.flip();
                                            ok2 = true;
                                            this.connection.send(pooledReply);
                                        }
                                        finally {
                                            if (!ok2) {
                                                pooledReply.free();
                                            }
                                        }
                                        ok1 = true;
                                        this.connection.getExecutor().execute(SpiUtils.getServiceOpenTask(connectionChannel, openListener));
                                        continue block55;
                                    }
                                    finally {
                                        if (ok1) continue block55;
                                        this.handler.handleInboundChannelClosed();
                                        continue block55;
                                    }
                                }
                                case 48: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) {
                                        RemoteLogger.log.tracef("Ignoring message data for expired channel", new Object[0]);
                                        break;
                                    }
                                    connectionChannel.handleMessageData(pooled);
                                    pooled = this.connection.allocate();
                                    buffer = (ByteBuffer)pooled.getResource();
                                    break;
                                }
                                case 49: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) {
                                        RemoteLogger.log.tracef("Ignoring window open for expired channel", new Object[0]);
                                        break;
                                    }
                                    connectionChannel.handleWindowOpen(pooled);
                                    break;
                                }
                                case 50: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) break;
                                    connectionChannel.handleAsyncClose(pooled);
                                    break;
                                }
                                case 33: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) break;
                                    connectionChannel.handleRemoteClose();
                                    break;
                                }
                                case 32: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) break;
                                    connectionChannel.handleIncomingWriteShutdown();
                                    break;
                                }
                                case 17: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    if ((channelId & -2147483648) == 0 || (pendingChannel = this.handler.removePendingChannel(channelId)) == null) break;
                                    outboundWindow = pendingChannel.getOutboundWindowSize();
                                    inboundWindow = pendingChannel.getInboundWindowSize();
                                    outboundMessageCount = pendingChannel.getOutboundMessageCount();
                                    inboundMessageCount = pendingChannel.getInboundMessageCount();
                                    block57: while (true) {
                                        switch (buffer.get() & 255) {
                                            case 128: {
                                                outboundWindow = ProtocolUtils.readInt(buffer);
                                                continue block57;
                                            }
                                            case 129: {
                                                outboundMessageCount = ProtocolUtils.readUnsignedShort(buffer);
                                                continue block57;
                                            }
                                            case 0: {
                                                break block57;
                                            }
                                            default: {
                                                Buffers.skip((Buffer)buffer, (int)(buffer.get() & 255));
                                                continue block57;
                                            }
                                        }
                                        break;
                                    }
                                    newChannel = new RemoteConnectionChannel(this.handler, this.connection, channelId, outboundWindow, inboundWindow, outboundMessageCount, inboundMessageCount);
                                    this.handler.putChannel(newChannel);
                                    pendingChannel.getResult().setResult((Object)newChannel);
                                    break;
                                }
                                default: {
                                    RemoteLogger.log.unknownProtocolId(protoId);
                                }
                            }
                        }
                        catch (BufferUnderflowException e) {
                            RemoteLogger.log.bufferUnderflow(protoId);
                        }
                    }
                }
                catch (BufferUnderflowException e) {
                    RemoteLogger.log.bufferUnderflowRaw();
                    continue;
                }
                finally {
                    buffer.clear();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refuseService(int channelId, String reason) {
        Pooled<ByteBuffer> pooledReply = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer replyBuffer = (ByteBuffer)pooledReply.getResource();
            replyBuffer.clear();
            replyBuffer.put((byte)19);
            replyBuffer.putInt(channelId);
            replyBuffer.put(reason.getBytes(Protocol.UTF_8));
            replyBuffer.flip();
            ok = true;
            this.connection.send(pooledReply);
        }
        finally {
            if (!ok) {
                pooledReply.free();
            }
        }
    }
}

