/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.regex.Pattern;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.LocalConnectionProvider;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.UnlockedReadHashMap;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.security.PasswordClientCallbackHandler;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.SpiUtils;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Result;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final Logger log;
    private static final RemotingPermission REGISTER_SERVICE_PERM;
    private static final RemotingPermission CONNECT_PERM;
    private static final RemotingPermission ADD_CONNECTION_PROVIDER_PERM;
    private static final RemotingPermission GET_CONNECTION_PROVIDER_INTERFACE_PERM;
    private static final int CLOSED_FLAG = Integer.MIN_VALUE;
    private static final int COUNT_MASK = Integer.MAX_VALUE;
    private static final String FQCN;
    private final Set<ConnectionImpl> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Attachments attachments = new Attachments();
    private final ConcurrentMap<String, ConnectionProvider> connectionProviders = new UnlockedReadHashMap<String, ConnectionProvider>();
    private final ConcurrentMap<String, OpenListener> registeredServices = new UnlockedReadHashMap<String, OpenListener>();
    private final Xnio xnio;
    private final XnioWorker worker;
    private final ThreadPoolExecutor executor;
    private static final AtomicIntegerFieldUpdater<EndpointImpl> resourceCountUpdater;
    private volatile int resourceCount = 0;
    private static final Pattern VALID_SERVICE_PATTERN;
    private final String name;
    private final OptionMap optionMap;
    private final ConnectionProviderContext connectionProviderContext;
    private final CloseHandler<Object> resourceCloseHandler = new CloseHandler<Object>(){

        @Override
        public void handleClose(Object closed, IOException exception) {
            EndpointImpl.this.closeTick1(closed);
        }
    };
    private final ConnectionCloseHandler connectionCloseHandler = new ConnectionCloseHandler();
    private static final Charset UTF_8;
    private static final UserAndRealm EMPTY;

    private EndpointImpl(Pool executor, Xnio xnio, String name, OptionMap optionMap) throws IOException {
        super(executor);
        executor.stopTask = new Runnable(){

            @Override
            public void run() {
                log.tracef("Finished final shutdown of %s", (Object)EndpointImpl.this);
                EndpointImpl.this.closeComplete();
            }
        };
        executor.allowCoreThreadTimeOut(true);
        this.executor = executor;
        if (xnio == null) {
            throw new IllegalArgumentException("xnio is null");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("optionMap is null");
        }
        this.xnio = xnio;
        this.name = name;
        String workerName = name == null ? "Remoting (anonymous)" : "Remoting \"" + name + "\"";
        this.optionMap = optionMap;
        this.connectionProviderContext = new ConnectionProviderContextImpl();
        this.connectionProviders.put("local", new LocalConnectionProvider(this.connectionProviderContext, executor));
        this.worker = xnio.createWorker(OptionMap.builder().addAll(optionMap).set(Options.WORKER_NAME, (Object)workerName).getMap());
        log.tracef("Completed open of %s", (Object)this);
    }

    private EndpointImpl(int poolSize, Xnio xnio, String name, OptionMap optionMap) throws IOException {
        this(new Pool(poolSize, poolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new EndpointThreadFactory(name)), xnio, name, optionMap);
    }

    EndpointImpl(Xnio xnio, String name, OptionMap optionMap) throws IOException {
        this(optionMap.get(RemotingOptions.TASK_THREAD_POOL_SIZE, 4), xnio, name, optionMap);
    }

    @Override
    protected Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void closeTick1(Object c) {
        int res = resourceCountUpdater.decrementAndGet(this);
        if (res == Integer.MIN_VALUE) {
            this.finishPhase1();
        } else if ((res & Integer.MIN_VALUE) != 0) {
            if (log.isTraceEnabled()) {
                log.logf(FQCN, Logger.Level.TRACE, null, "Phase 1 shutdown count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
            }
        } else if (log.isTraceEnabled()) {
            log.logf(FQCN, Logger.Level.TRACE, null, "Resource closed count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
        }
    }

    private void finishPhase1() {
        log.tracef("Finished phase 1 shutdown of %s", (Object)this);
        IoUtils.safeClose((Closeable)this.worker);
        this.executor.shutdown();
    }

    void resourceUntick(Object opened) throws NotOpenException {
        int old;
        do {
            if (((old = resourceCountUpdater.get(this)) & Integer.MIN_VALUE) == 0) continue;
            throw new NotOpenException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    @Override
    protected void closeAction() throws IOException {
        int res;
        while (!resourceCountUpdater.compareAndSet(this, res = this.resourceCount, res | Integer.MIN_VALUE)) {
        }
        if (res == 0) {
            this.finishPhase1();
        } else {
            for (Object connection : this.connections.toArray()) {
                ((ConnectionImpl)connection).closeAsync();
            }
            for (ConnectionProvider connectionProvider : this.connectionProviders.values()) {
                connectionProvider.closeAsync();
            }
        }
    }

    @Override
    public Registration registerService(String serviceType, final OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
        OpenListener existing;
        if (!VALID_SERVICE_PATTERN.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type must match " + VALID_SERVICE_PATTERN);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_SERVICE_PERM);
        }
        if ((existing = this.registeredServices.putIfAbsent(serviceType, openListener)) != null) {
            throw new ServiceRegistrationException("Service type '" + serviceType + "' is already registered");
        }
        MapRegistration<OpenListener> registration = new MapRegistration<OpenListener>(this.registeredServices, serviceType, openListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void closeAction() throws IOException {
                try {
                    openListener.registrationTerminated();
                }
                finally {
                    super.closeAction();
                }
            }
        };
        final HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
        registration.addCloseHandler(new CloseHandler<Registration>(){

            @Override
            public void handleClose(Registration closed, IOException exception) {
                key.remove();
            }
        });
        return registration;
    }

    @Override
    public IoFuture<Connection> connect(URI destination) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder();
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTHORIZE_ID), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoFuture<Connection> doConnect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONNECT_PERM);
        }
        boolean ok = false;
        this.resourceUntick("Connection to " + destination);
        try {
            String scheme = destination.getScheme();
            ConnectionProvider connectionProvider = (ConnectionProvider)this.connectionProviders.get(scheme);
            if (connectionProvider == null) {
                throw new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed");
            }
            final FutureResult futureResult = new FutureResult(this.getExecutor());
            final StackTraceElement[] mark = Thread.currentThread().getStackTrace();
            Cancellable connect = connectionProvider.connect(destination, connectOptions, new Result<ConnectionHandlerFactory>(){
                private final AtomicBoolean called = new AtomicBoolean();

                public boolean setResult(ConnectionHandlerFactory result) {
                    if (this.called.getAndSet(true)) {
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Got redundant complete result %s", (Object)result);
                        return false;
                    }
                    log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Registered successful result %s", (Object)result);
                    ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, result, EndpointImpl.this.connectionProviderContext);
                    EndpointImpl.this.connections.add(connection);
                    connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                    connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                    connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                    return futureResult.setResult((Object)connection);
                }

                public boolean setException(IOException exception) {
                    if (this.called.getAndSet(true)) {
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)exception, "Got redundant exception result", new Object[0]);
                        return false;
                    }
                    log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)exception, "Registered exception result", new Object[0]);
                    EndpointImpl.this.closeTick1("a failed connection (2)");
                    SpiUtils.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                    return futureResult.setException(exception);
                }

                public boolean setCancelled() {
                    if (this.called.getAndSet(true)) {
                        log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Got redundant cancellation result", new Object[0]);
                        return false;
                    }
                    log.logf(this.getClass().getName(), Logger.Level.TRACE, null, "Registered cancellation result", new Object[0]);
                    EndpointImpl.this.closeTick1("a cancelled connection");
                    return futureResult.setCancelled();
                }
            }, callbackHandler);
            ok = true;
            futureResult.addCancelHandler(connect);
            IoFuture ioFuture = futureResult.getIoFuture();
            return ioFuture;
        }
        finally {
            if (!ok) {
                this.closeTick1("a failed connection (1)");
            }
        }
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, callbackHandler);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password) throws IOException {
        String actualUserName;
        UserAndRealm userRealm = this.getUserAndRealm(destination);
        String uriUserName = userRealm.getUser();
        String uriUserRealm = userRealm.getRealm();
        String string = userName != null ? userName : (actualUserName = uriUserName != null ? uriUserName : (String)connectOptions.get(RemotingOptions.AUTHORIZE_ID));
        String actualUserRealm = realmName != null ? realmName : (uriUserRealm != null ? uriUserRealm : (String)connectOptions.get(RemotingOptions.AUTH_REALM));
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (actualUserName != null) {
            builder.set(RemotingOptions.AUTHORIZE_ID, (Object)actualUserName);
        }
        if (actualUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)actualUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new PasswordClientCallbackHandler(actualUserName, actualUserRealm, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory, OptionMap optionMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONNECTION_PROVIDER_PERM);
        }
        boolean ok = false;
        this.resourceUntick("Connection provider for " + uriScheme);
        try {
            MapRegistration<ConnectionProvider> mapRegistration;
            block10: {
                ConnectionProviderContextImpl context = new ConnectionProviderContextImpl();
                final ConnectionProvider provider = providerFactory.createInstance(context, optionMap);
                try {
                    if (this.connectionProviders.putIfAbsent(uriScheme, provider) != null) {
                        throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
                    }
                    log.tracef("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
                    final MapRegistration<ConnectionProvider> registration = new MapRegistration<ConnectionProvider>(this.connectionProviders, uriScheme, provider){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void closeAction() throws IOException {
                            try {
                                provider.closeAsync();
                            }
                            finally {
                                super.closeAction();
                            }
                        }
                    };
                    provider.addCloseHandler(new CloseHandler<ConnectionProvider>(){

                        @Override
                        public void handleClose(ConnectionProvider closed, IOException exception) {
                            registration.closeAsync();
                            EndpointImpl.this.closeTick1(closed);
                        }
                    });
                    ok = true;
                    mapRegistration = registration;
                    if (ok) break block10;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        provider.close();
                    }
                    throw throwable;
                }
                provider.close();
            }
            return mapRegistration;
        }
        finally {
            if (!ok) {
                this.closeTick1("Connection provider for " + uriScheme);
            }
        }
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONNECTION_PROVIDER_INTERFACE_PERM);
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ConnectionProvider provider = (ConnectionProvider)this.connectionProviders.get(uriScheme);
        if (provider == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(provider.getProviderInterface());
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.connectionProviders.containsKey(uriScheme);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("endpoint ");
        if (this.name != null) {
            b.append('\"').append(this.name).append('\"');
        } else {
            b.append("(anonymous)");
        }
        b.append(" <").append(Integer.toHexString(this.hashCode())).append(">");
        return b.toString();
    }

    private static String uriDecode(String encoded) {
        char[] chars = encoded.toCharArray();
        int olen = chars.length;
        byte[] buf = new byte[olen];
        int c = 0;
        for (int i = 0; i < olen; ++i) {
            char ch = chars[i];
            if (ch == '%') {
                buf[c++] = (byte)(Character.digit(chars[++i], 16) << 4 | Character.digit(chars[++i], 16));
                continue;
            }
            if (ch < ' ' || ch > '\u007f') continue;
            buf[c++] = (byte)ch;
        }
        return new String(buf, 0, c, UTF_8);
    }

    private UserAndRealm getUserAndRealm(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo == null) {
            return EMPTY;
        }
        int i = userInfo.indexOf(59);
        if (i == -1) {
            return new UserAndRealm(uri.getUserInfo(), null);
        }
        return new UserAndRealm(EndpointImpl.uriDecode(userInfo.substring(0, i)), EndpointImpl.uriDecode(userInfo.substring(i + 1)));
    }

    static {
        Logger.getLogger((String)"org.jboss.remoting").infof("JBoss Remoting version %s", (Object)Version.VERSION);
        log = Logger.getLogger((String)"org.jboss.remoting.endpoint");
        REGISTER_SERVICE_PERM = new RemotingPermission("registerService");
        CONNECT_PERM = new RemotingPermission("connect");
        ADD_CONNECTION_PROVIDER_PERM = new RemotingPermission("addConnectionProvider");
        GET_CONNECTION_PROVIDER_INTERFACE_PERM = new RemotingPermission("getConnectionProviderInterface");
        FQCN = EndpointImpl.class.getName();
        resourceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointImpl.class, "resourceCount");
        VALID_SERVICE_PATTERN = Pattern.compile("[-.:a-zA-Z_0-9]+");
        UTF_8 = Charset.forName("UTF-8");
        EMPTY = new UserAndRealm(null, null);
    }

    private class ConnectionCloseHandler
    implements CloseHandler<Connection> {
        private ConnectionCloseHandler() {
        }

        @Override
        public void handleClose(Connection closed, IOException exception) {
            EndpointImpl.this.connections.remove(closed);
        }
    }

    static final class Pool
    extends ThreadPoolExecutor {
        private static final String FQCN = Pool.class.getName();
        volatile Runnable stopTask;

        Pool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @Override
        public void execute(Runnable command) {
            super.execute(command);
            log.logf(FQCN, Logger.Level.TRACE, null, "Accepted %s for execution", (Object)command);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            log.tracef("Initiating execution of %s", (Object)r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            log.tracef(t, "Completed execution of %s", (Object)r);
        }

        @Override
        protected void terminated() {
            Runnable task = this.stopTask;
            if (task != null) {
                task.run();
            }
        }
    }

    static final class EndpointThread
    extends Thread {
        EndpointThread(Runnable target, String name) {
            super(target, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                log.tracef("Endpoint thread %s exiting", (Object)this);
            }
        }
    }

    static final class EndpointThreadFactory
    implements ThreadFactory {
        private final String name;
        private volatile int threadId = 1;
        private static final AtomicIntegerFieldUpdater<EndpointThreadFactory> threadIdUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointThreadFactory.class, "threadId");

        EndpointThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            int id = threadIdUpdater.getAndIncrement(this);
            String threadName = this.name == null ? String.format("Remoting (anonymous) task-%d", id) : String.format("Remoting \"%s\" task-%d", this.name, id);
            EndpointThread thread = new EndpointThread(r, threadName);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.errorf(e, "Uncaught exception in thread %s", (Object)t);
                }
            });
            return thread;
        }
    }

    private final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private ConnectionProviderContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory) {
            try {
                EndpointImpl.this.resourceUntick("an inbound connection");
            }
            catch (NotOpenException e) {
                throw new IllegalStateException("Accept after endpoint close", e);
            }
            boolean ok = false;
            try {
                ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this);
                EndpointImpl.this.connections.add(connection);
                connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                ok = true;
            }
            finally {
                if (!ok) {
                    EndpointImpl.this.closeTick1("a failed inbound connection");
                }
            }
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }

        @Override
        public Xnio getXnio() {
            return EndpointImpl.this.xnio;
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.executor;
        }

        @Override
        public XnioWorker getXnioWorker() {
            return EndpointImpl.this.worker;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final Connection connection;

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, Connection connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        @Override
        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        @Override
        public OpenListener getServiceOpenListener(String serviceType) {
            return (OpenListener)EndpointImpl.this.registeredServices.get(serviceType);
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void remoteClosed() {
            this.connection.closeAsync();
        }
    }

    private class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        private MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super(EndpointImpl.this.executor, false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() throws IOException {
            this.map.remove(this.key, this.value);
            this.closeComplete();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }

    static final class UserAndRealm {
        private final String user;
        private final String realm;

        UserAndRealm(String user, String realm) {
            this.user = user;
            this.realm = realm;
        }

        public String getUser() {
            return this.user;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

