/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.Protocol;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ClientConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final CallbackHandler callbackHandler;
    private final AccessControlContext accessControlContext;
    private final OptionMap optionMap;
    private final Set<String> failedMechs = new HashSet<String>();
    private final Set<String> allowedMechs;
    private final Set<String> disallowedMechs;

    ClientConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, CallbackHandler callbackHandler, AccessControlContext accessControlContext, OptionMap optionMap) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.callbackHandler = callbackHandler;
        this.accessControlContext = accessControlContext;
        this.optionMap = optionMap;
        Sequence allowedMechs = (Sequence)optionMap.get(Options.SASL_MECHANISMS);
        Sequence disallowedMechs = (Sequence)optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        this.allowedMechs = allowedMechs == null ? null : new HashSet(allowedMechs);
        this.disallowedMechs = disallowedMechs == null ? Collections.emptySet() : new HashSet(disallowedMechs);
    }

    public void handleEvent(ConnectedMessageChannel channel) {
        this.connection.setReadListener(new Greeting());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCapRequest(String remoteServerName) {
        RemoteLogger.client.trace("Client sending capabilities request");
        Pooled<ByteBuffer> pooledSendBuffer = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
            sendBuffer.put((byte)1);
            ProtocolUtils.writeByte(sendBuffer, 0, 1);
            String localEndpointName = this.connectionProviderContext.getEndpoint().getName();
            if (localEndpointName != null) {
                ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
            }
            sendBuffer.flip();
            this.connection.setReadListener(new Capabilities(remoteServerName));
            this.connection.send(pooledSendBuffer);
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                pooledSendBuffer.free();
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslClient saslClient;
        private final String serverName;
        private final String authorizationID;
        private final String remoteEndpointName;

        Authentication(SaslClient saslClient, String serverName, String authorizationID, String remoteEndpointName) {
            this.saslClient = saslClient;
            this.serverName = serverName;
            this.authorizationID = authorizationID;
            this.remoteEndpointName = remoteEndpointName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                final ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledBuffer.free();
                    return;
                }
                if (res == 0) {
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                buffer.flip();
                final byte msgType = buffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 3: {
                        RemoteLogger.client.trace("Client received authentication challenge");
                        ClientConnectionOpenListener.this.connection.getChannel().suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                byte[] response;
                                boolean clientComplete = Authentication.this.saslClient.isComplete();
                                if (clientComplete) {
                                    ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                    return;
                                }
                                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                try {
                                    response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                    if (msgType == 5 && response != null && response.length > 0) {
                                        ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                        return;
                                    }
                                }
                                catch (Throwable e) {
                                    String mechanismName = Authentication.this.saslClient.getMechanismName();
                                    RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                    ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                                    ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                    ClientConnectionOpenListener.this.connection.getChannel().resumeReads();
                                    return;
                                }
                                RemoteLogger.client.trace("Client sending authentication response");
                                Pooled<ByteBuffer> pooled = ClientConnectionOpenListener.this.connection.allocate();
                                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                sendBuffer.put((byte)4);
                                sendBuffer.put(response);
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.send(pooled);
                                ClientConnectionOpenListener.this.connection.getChannel().resumeReads();
                            }
                        });
                        return;
                    }
                    case 5: {
                        RemoteLogger.client.trace("Client received authentication complete");
                        ClientConnectionOpenListener.this.connection.getChannel().suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                Object qop;
                                boolean clientComplete = Authentication.this.saslClient.isComplete();
                                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                if (!clientComplete) {
                                    try {
                                        byte[] response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                        if (response != null && response.length > 0) {
                                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                            return;
                                        }
                                        if (!Authentication.this.saslClient.isComplete()) {
                                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Client not complete after processing auth complete message"));
                                            return;
                                        }
                                    }
                                    catch (Throwable e) {
                                        String mechanismName = Authentication.this.saslClient.getMechanismName();
                                        RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                        ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                                        ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                        return;
                                    }
                                }
                                if ("auth-int".equals(qop = Authentication.this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) || "auth-conf".equals(qop)) {
                                    ClientConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslClient)Authentication.this.saslClient));
                                }
                                ConnectionHandlerFactory connectionHandlerFactory = new ConnectionHandlerFactory(){

                                    @Override
                                    public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                        RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientConnectionOpenListener.this.connection, Authentication.this.authorizationID, Authentication.this.remoteEndpointName);
                                        ClientConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ClientConnectionOpenListener.this.connection));
                                        return connectionHandler;
                                    }
                                };
                                ClientConnectionOpenListener.this.connection.getResult().setResult((Object)connectionHandlerFactory);
                                ClientConnectionOpenListener.this.connection.getChannel().resumeReads();
                            }
                        });
                        return;
                    }
                    case 6: {
                        String mechanismName = this.saslClient.getMechanismName();
                        RemoteLogger.client.debugf("Client received authentication rejected for mechanism %s", mechanismName);
                        ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                        ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledBuffer.free();
            }
        }
    }

    final class StartTls
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        StartTls(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", receiveBuffer);
                receiveBuffer.flip();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 7: {
                        RemoteLogger.client.trace("Client received STARTTLS response");
                        try {
                            ((SslChannel)channel).startHandshake();
                        }
                        catch (IOException e) {
                            ClientConnectionOpenListener.this.connection.handleException(e, false);
                            pooledReceiveBuffer.free();
                            return;
                        }
                        ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Capabilities
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        Capabilities(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                receiveBuffer.flip();
                boolean starttls = false;
                LinkedHashSet<String> saslMechs = new LinkedHashSet<String>();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 1: {
                        RemoteLogger.client.trace("Client received capabilities response");
                        String remoteEndpointName = null;
                        int version = 1;
                        block34: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    version = data.get() & 0xFF;
                                    RemoteLogger.client.tracef("Client received capability: version %d", version & 0xFF);
                                    continue block34;
                                }
                                case 1: {
                                    String mechName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: SASL mechanism %s", mechName);
                                    if (ClientConnectionOpenListener.this.failedMechs.contains(mechName) || ClientConnectionOpenListener.this.disallowedMechs.contains(mechName) || ClientConnectionOpenListener.this.allowedMechs != null && !ClientConnectionOpenListener.this.allowedMechs.contains(mechName)) continue block34;
                                    RemoteLogger.client.tracef("SASL mechanism %s added to allowed set", mechName);
                                    saslMechs.add(mechName);
                                    continue block34;
                                }
                                case 2: {
                                    RemoteLogger.client.trace("Client received capability: STARTTLS");
                                    starttls = true;
                                    continue block34;
                                }
                                case 3: {
                                    remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: remote endpoint name \"%s\"", remoteEndpointName);
                                    continue block34;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown capability %02x", type & 0xFF);
                        }
                        if (starttls && ClientConnectionOpenListener.this.optionMap.get(Options.SSL_STARTTLS, true)) {
                            Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                            ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                            sendBuffer.put((byte)7);
                            sendBuffer.flip();
                            ClientConnectionOpenListener.this.connection.setReadListener(new StartTls(this.remoteServerName));
                            ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                            return;
                        }
                        if (saslMechs.isEmpty()) {
                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Authentication failed: No authentication mechanisms are available"));
                            return;
                        }
                        OptionMap optionMap = ClientConnectionOpenListener.this.connection.getOptionMap();
                        final String userName = (String)optionMap.get(RemotingOptions.AUTHORIZE_ID);
                        Map propertyMap = SaslUtils.createPropertyMap((OptionMap)optionMap, (boolean)Channels.getOption((Configurable)channel, (Option)Options.SECURE, (boolean)false));
                        SaslClient saslClient = null;
                        try {
                            SaslClientFactory factory;
                            Iterator iterator = SaslUtils.getSaslClientFactories((ClassLoader)this.getClass().getClassLoader(), (boolean)true);
                            while (iterator.hasNext() && (saslClient = AccessController.doPrivileged(new PrivilegedExceptionAction<SaslClient>(factory = (SaslClientFactory)iterator.next(), saslMechs, userName, propertyMap){
                                final /* synthetic */ SaslClientFactory val$factory;
                                final /* synthetic */ Set val$saslMechs;
                                final /* synthetic */ String val$userName;
                                final /* synthetic */ Map val$propertyMap;
                                {
                                    this.val$factory = saslClientFactory;
                                    this.val$saslMechs = set;
                                    this.val$userName = string;
                                    this.val$propertyMap = map;
                                }

                                @Override
                                public SaslClient run() throws SaslException {
                                    return this.val$factory.createSaslClient(this.val$saslMechs.toArray(new String[this.val$saslMechs.size()]), this.val$userName, "remote", Capabilities.this.remoteServerName, this.val$propertyMap, ClientConnectionOpenListener.this.callbackHandler);
                                }
                            }, ClientConnectionOpenListener.this.accessControlContext)) == null) {
                            }
                        }
                        catch (PrivilegedActionException e) {
                            SaslException se = (SaslException)e.getCause();
                            ClientConnectionOpenListener.this.connection.handleException(se);
                            pooledReceiveBuffer.free();
                            return;
                        }
                        if (saslClient == null) {
                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Authentication failed: all available authentication mechanisms failed"));
                            return;
                        }
                        final String mechanismName = saslClient.getMechanismName();
                        RemoteLogger.client.tracef("Client initiating authentication using mechanism %s", mechanismName);
                        final String theRemoteEndpointName = remoteEndpointName;
                        ClientConnectionOpenListener.this.connection.getChannel().suspendReads();
                        final int negotiatedVersion = version;
                        final SaslClient usedSaslClient = saslClient;
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                byte[] response;
                                try {
                                    response = usedSaslClient.hasInitialResponse() && negotiatedVersion >= 1 ? usedSaslClient.evaluateChallenge(SaslUtils.EMPTY_BYTES) : null;
                                }
                                catch (Exception e) {
                                    RemoteLogger.client.tracef("Client authentication failed: %s", e);
                                    ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                                    ClientConnectionOpenListener.this.sendCapRequest(Capabilities.this.remoteServerName);
                                    return;
                                }
                                Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                                ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                                sendBuffer.put((byte)2);
                                if (negotiatedVersion < 1) {
                                    sendBuffer.put(mechanismName.getBytes(Protocol.UTF_8));
                                } else {
                                    ProtocolUtils.writeString(sendBuffer, mechanismName);
                                    if (response != null) {
                                        sendBuffer.put(response);
                                    }
                                }
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.setReadListener(new Authentication(usedSaslClient, Capabilities.this.remoteServerName, userName, theRemoteEndpointName));
                                ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                ClientConnectionOpenListener.this.connection.getChannel().resumeReads();
                            }
                        });
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Greeting
    implements ChannelListener<ConnectedMessageChannel> {
        Greeting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", receiveBuffer);
                receiveBuffer.flip();
                String remoteServerName = null;
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 0: {
                        RemoteLogger.client.trace("Client received greeting");
                        block25: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    remoteServerName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received server name: %s", remoteServerName);
                                    continue block25;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown greeting message %02x", type & 0xFF);
                        }
                        if (remoteServerName == null) {
                            remoteServerName = ((InetSocketAddress)channel.getPeerAddress(InetSocketAddress.class)).getHostName();
                        }
                        ClientConnectionOpenListener.this.sendCapRequest(remoteServerName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }
}

