/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.config.ResteasyConfigSource;

public class ServletContextConfigSource
implements ResteasyConfigSource {
    private volatile String name;

    public Map<String, String> getProperties() {
        ServletContext context = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
        if (context == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration keys = context.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, context.getInitParameter(key));
            }
        }
        return map;
    }

    public Set<String> getPropertyNames() {
        ServletContext context = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
        if (context == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Collections.list(context.getInitParameterNames()));
    }

    public String getValue(String propertyName) {
        ServletContext context = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
        if (context == null) {
            return null;
        }
        return context.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String currentName = this.name;
        if (currentName == null) {
            ServletContextConfigSource servletContextConfigSource = this;
            synchronized (servletContextConfigSource) {
                currentName = this.name;
                if (currentName == null) {
                    ServletContext servletContext = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = currentName = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(":ServletContextConfigSource").toString();
                }
            }
        }
        return currentName;
    }

    @Override
    public int getDefaultOrdinal() {
        return 40;
    }
}

