/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.ejb;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.ejb.Book;
import org.jboss.resteasy.cdi.ejb.EJBBookReader;
import org.jboss.resteasy.cdi.ejb.EJBBookReaderImpl;
import org.jboss.resteasy.cdi.ejb.EJBBookWriterImpl;
import org.jboss.resteasy.cdi.ejb.EJBLocalResource;
import org.jboss.resteasy.cdi.ejb.EJBRemoteResource;
import org.jboss.resteasy.cdi.util.Counter;
import org.jboss.resteasy.cdi.util.CounterBinding;
import org.jboss.resteasy.cdi.util.Utilities;

@Stateless
@Dependent
@Path(value="/")
public class EJBBookResource
implements EJBLocalResource,
EJBRemoteResource {
    private static HashMap<Integer, Book> books = new HashMap();
    @Inject
    private Logger log;
    @Inject
    private Utilities utilities;
    @Inject
    @CounterBinding
    private Counter counter;
    @Inject
    private EJBBookReader readerCDI;
    @EJB
    private EJBBookReader readerEJB;
    @Inject
    private EJBBookWriterImpl writerCDI;
    @EJB
    private EJBBookWriterImpl writerEJB;

    @Override
    @GET
    @Path(value="verifyScopes")
    public int verifyScopes() {
        this.log.info("entering verifyScopes()");
        this.log.info("EJBBookReader scope:      " + this.utilities.getScope(EJBBookReader.class));
        this.log.info("EJBBookReaderImpl scope:  " + this.utilities.getScope(EJBBookReaderImpl.class));
        this.log.info("EJBBookWriterImpl scope:  " + this.utilities.getScope(EJBBookWriterImpl.class));
        this.log.info("EJBLocalResource scope:   " + this.utilities.getScope(EJBLocalResource.class));
        this.log.info("EJBRemoteResource scope:  " + this.utilities.getScope(EJBRemoteResource.class));
        this.log.info("EJBBookResource scope:    " + this.utilities.getScope(EJBBookResource.class));
        boolean result = true;
        result &= this.utilities.isApplicationScoped(EJBBookReader.class);
        result &= this.utilities.isApplicationScoped(EJBBookWriterImpl.class);
        return (result &= this.utilities.isDependentScoped(EJBLocalResource.class)) ? 200 : 500;
    }

    @Override
    @GET
    @Path(value="verifyInjection")
    public int verifyInjection() {
        this.log.info("entering verifyInjection()");
        this.log.info("readerCDI: " + this.readerCDI);
        this.log.info("readerEJB: " + this.readerEJB);
        this.log.info("writerCDI: " + this.writerCDI);
        this.log.info("writerEJB: " + this.writerEJB);
        boolean result = true;
        result &= this.readerCDI != null;
        result &= this.readerEJB != null;
        result &= this.writerCDI != null;
        return (result &= this.writerEJB != null) ? 200 : 500;
    }

    @Override
    @POST
    @Path(value="create")
    @Consumes(value={"application/test+xml"})
    public int createBook(Book book) {
        this.log.info("entering createBook()");
        int id = this.counter.getNext();
        book.setId(id);
        books.put(id, book);
        this.log.info("stored: " + id + "->" + book);
        return id;
    }

    @Override
    @GET
    @Path(value="book/{id:[0-9][0-9]*}")
    @Produces(value={"application/test+xml"})
    public Book lookupBookById(@PathParam(value="id") int id) {
        this.log.info("entering lookupBookById(" + id + ")");
        this.log.info("books: " + books);
        Book book = books.get(id);
        if (book == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return book;
    }

    @Override
    @GET
    @Path(value="uses/{count}")
    public int testUse(@PathParam(value="count") int count) {
        this.log.info("entering testUse()");
        this.log.info("readerEJB uses: " + this.readerEJB.getUses());
        this.log.info("writerEJB uses: " + this.writerEJB.getUses());
        this.log.info("readerCDI uses: " + this.readerCDI.getUses());
        this.log.info("writerCDI uses: " + this.writerCDI.getUses());
        int readerUses = this.readerCDI.getUses();
        int writerUses = this.writerCDI.getUses();
        this.readerCDI.reset();
        this.writerCDI.reset();
        return readerUses == count && writerUses == count ? 200 : 500;
    }

    @Override
    @GET
    @Path(value="reset")
    public void reset() {
        this.log.info("entering reset()");
        this.counter.reset();
    }
}

