/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.events.Book;
import org.jboss.resteasy.cdi.events.BookReader;
import org.jboss.resteasy.cdi.events.Process;
import org.jboss.resteasy.cdi.events.Read;
import org.jboss.resteasy.cdi.events.Write;

@Path(value="/")
@RequestScoped
public class EventResource {
    private static Map<Integer, Book> collection = new HashMap<Integer, Book>();
    private static AtomicInteger counter = new AtomicInteger();
    @Inject
    @Process
    Event<String> processEvent;
    @Inject
    @Read(context="resource")
    @Process
    Event<String> readProcessEvent;
    @Inject
    @Write(context="resource")
    @Process
    Event<String> writeProcessEvent;
    @Inject
    BookReader bookReader;
    @Inject
    private Logger log;

    @POST
    @Path(value="test")
    @Produces(value={"text/plain"})
    public Response test() {
        this.log.info("entering EventResource.test()");
        this.log.info("event list:");
        ArrayList<Object> eventList = this.bookReader.getEventList();
        for (int i = 0; i < eventList.size(); ++i) {
            this.log.info(eventList.get(i).toString());
        }
        boolean status = true;
        if (eventList.size() != 20) {
            status = false;
            this.log.info("should have 20 events, not " + eventList.size());
        }
        if (!"readInterceptEvent".equals(eventList.get(0))) {
            status = false;
            this.log.info("missing readInterceptEvent");
        }
        if (!"readInterceptEvent".equals(eventList.get(1))) {
            status = false;
            this.log.info("missing readInterceptEvent");
        }
        if (!"readEvent".equals(eventList.get(2))) {
            status = false;
            this.log.info("missing readEvent");
        }
        if (!"readEvent".equals(eventList.get(3))) {
            status = false;
            this.log.info("missing readEvent");
        }
        if (!"processEvent".equals(eventList.get(4))) {
            status = false;
            this.log.info("missing processEvent");
        }
        if (!"readProcessEvent".equals(eventList.get(5))) {
            status = false;
            this.log.info("missing readProcessEvent");
        }
        if (!"readProcessEvent".equals(eventList.get(6))) {
            status = false;
            this.log.info("missing readProcessEvent");
        }
        if (!"writeInterceptEvent".equals(eventList.get(7))) {
            status = false;
            this.log.info("missing writeInterceptEvent");
        }
        if (!"writeInterceptEvent".equals(eventList.get(8))) {
            status = false;
            this.log.info("missing writeInterceptEvent");
        }
        if (!"processEvent".equals(eventList.get(9))) {
            status = false;
            this.log.info("missing processEvent");
        }
        if (!"writeProcessEvent".equals(eventList.get(10))) {
            status = false;
            this.log.info("missing writeProcessEvent");
        }
        if (!"writeProcessEvent".equals(eventList.get(11))) {
            status = false;
            this.log.info("missing writeProcessEvent");
        }
        if (!"writeInterceptEvent".equals(eventList.get(12))) {
            status = false;
            this.log.info("missing writeInterceptEvent");
        }
        if (!"writeInterceptEvent".equals(eventList.get(13))) {
            status = false;
            this.log.info("missing writeInterceptEvent");
        }
        if (!"writeEvent".equals(eventList.get(14))) {
            status = false;
            this.log.info("missing writeEvent");
        }
        if (!"writeEvent".equals(eventList.get(15))) {
            status = false;
            this.log.info("missing writeEvent");
        }
        if (!"readInterceptEvent".equals(eventList.get(16))) {
            status = false;
            this.log.info("missing readInterceptEvent");
        }
        if (!"readInterceptEvent".equals(eventList.get(17))) {
            status = false;
            this.log.info("missing readInterceptEvent");
        }
        if (!"readEvent".equals(eventList.get(18))) {
            status = false;
            this.log.info("missing readEvent");
        }
        if (!"readEvent".equals(eventList.get(19))) {
            status = false;
            this.log.info("missing readEvent");
        }
        this.log.info("leaving EventResource.test()");
        return status ? Response.ok().build() : Response.serverError().build();
    }

    @POST
    @Path(value="create")
    @Consumes(value={"application/test+xml"})
    @Produces(value={"text/plain"})
    public Response createBook(Book book) {
        this.log.info("entering EventResource.createBook()");
        this.log.info("EventResource firing processEvent");
        this.processEvent.fire((Object)"processEvent");
        int id = counter.getAndIncrement();
        book.setId(id);
        collection.put(id, book);
        this.log.info("stored: " + id + "->" + book);
        this.log.info("EventResource firing readProcessEvent");
        this.readProcessEvent.fire((Object)"readProcessEvent");
        this.log.info("leaving EventResource.createBook()");
        return Response.ok((Object)id).build();
    }

    @GET
    @Path(value="book/{id:[0-9][0-9]*}")
    @Produces(value={"application/test+xml"})
    public Book lookupBookById(@PathParam(value="id") int id) {
        this.log.info("entering EventResource.lookupBookById(" + id + ")");
        this.log.info("books: " + collection);
        this.log.info("EventResource firing processEvent");
        this.processEvent.fire((Object)"processEvent");
        Book book = collection.get(id);
        this.log.info("EventResource firing writeProcessEvent");
        this.writeProcessEvent.fire((Object)"writeProcessEvent");
        if (book == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.log.info("leaving EventResource.lookupBookById(" + id + ")");
        return book;
    }
}

