/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.generic;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.generic.HierarchyHolder;
import org.jboss.resteasy.cdi.generic.HolderBinding;
import org.jboss.resteasy.cdi.generic.LowerBoundHierarchyHolder;
import org.jboss.resteasy.cdi.generic.LowerBoundTypedResourceIntf;
import org.jboss.resteasy.cdi.generic.Primate;
import org.jboss.resteasy.cdi.generic.VisitList;

@Path(value="lowerbound")
@Dependent
public class LowerBoundTypedResource<T extends HierarchyHolder<? super Primate>>
implements LowerBoundTypedResourceIntf<T> {
    @Inject
    private Logger log;
    @Inject
    @HolderBinding
    LowerBoundHierarchyHolder<T> typeParameterLowerBound;
    private Class<?> clazz;

    public LowerBoundTypedResource() {
        System.out.println("LowerBoundTypedResource<?>(): " + this);
    }

    public LowerBoundTypedResource(Class<?> clazz) {
        this.clazz = clazz;
        System.out.println("LowerBoundTypedResource(" + clazz + "): " + this);
    }

    public Type getTypeArgument() {
        return this.clazz;
    }

    @Override
    @GET
    @Path(value="injection")
    public Response testGenerics() {
        this.log.info("entering LowerBoundTypedResource.testGenerics()");
        this.log.info(this.typeParameterLowerBound.getTypeArgument().toString());
        boolean result = true;
        if (!this.typeParameterLowerBound.getTypeArgument().equals(Primate.class)) {
            this.log.info("typeParameterLowerBound type argument class should be Primate instead of " + this.typeParameterLowerBound.getTypeArgument());
            result = false;
        }
        return result ? Response.ok().build() : Response.serverError().build();
    }

    @Override
    @GET
    @Path(value="decorators/clear")
    public Response clear() {
        System.out.println("entering UpperBoundTypedResource.clear()");
        VisitList.clear();
        return Response.ok().build();
    }

    @Override
    @GET
    @Path(value="decorators/execute")
    public Response execute() {
        System.out.println("entering UpperBoundTypedResource.execute()");
        return Response.ok().build();
    }

    @Override
    @GET
    @Path(value="decorators/test")
    public Response testDecorators() {
        int i;
        boolean status;
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add("lowerBoundDecoratorEnter");
        expectedList.add("lowerBoundDecoratorLeave");
        ArrayList<String> visitList = VisitList.getList();
        boolean bl = status = expectedList.size() == visitList.size();
        if (!status) {
            this.log.info("expectedList.size() [" + expectedList.size() + "] != visitList.size() [" + visitList.size() + "]");
        } else {
            for (i = 0; i < expectedList.size(); ++i) {
                if (((String)expectedList.get(i)).equals(visitList.get(i))) continue;
                status = false;
                this.log.info("visitList.get(" + i + ") incorrect: should be: " + (String)expectedList.get(i) + ", is: " + visitList.get(i));
                break;
            }
        }
        if (!status) {
            this.log.info("\rexpectedList: ");
            for (i = 0; i < expectedList.size(); ++i) {
                this.log.info(i + ": " + ((String)expectedList.get(i)).toString());
            }
            this.log.info("\rvisitList:");
            for (i = 0; i < visitList.size(); ++i) {
                this.log.info(i + ": " + visitList.get(i).toString());
            }
        }
        return status ? Response.ok().build() : Response.serverError().build();
    }
}

