/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.generic;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.generic.HolderBinding;
import org.jboss.resteasy.cdi.generic.ObjectHolder;
import org.jboss.resteasy.cdi.generic.ObjectTypedResourceIntf;
import org.jboss.resteasy.cdi.generic.VisitList;

@Path(value="object")
@Dependent
public class ObjectTypedResource<T>
implements ObjectTypedResourceIntf<T> {
    @Inject
    private Logger log;
    @Inject
    @HolderBinding
    ObjectHolder<T> typeParameterObject;

    @Override
    @GET
    @Path(value="injection")
    public Response testGenerics() {
        this.log.info("entering ObjectTypedResource.testGenerics()");
        this.log.info(this.typeParameterObject.getTypeArgument().toString());
        boolean result = true;
        if (!this.typeParameterObject.getTypeArgument().equals(Object.class)) {
            this.log.info("typeParameterObject type argument class should be Object instead of " + this.typeParameterObject.getTypeArgument());
            result = false;
        }
        return result ? Response.ok().build() : Response.serverError().build();
    }

    @Override
    @GET
    @Path(value="decorators")
    public Response testDecorators() {
        int i;
        boolean status;
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add("concreteDecoratorEnter");
        expectedList.add("concreteDecoratorLeave");
        ArrayList<String> visitList = VisitList.getList();
        boolean bl = status = expectedList.size() == visitList.size();
        if (!status) {
            this.log.info("expectedList.size() [" + expectedList.size() + "] != visitList.size() [" + visitList.size() + "]");
        } else {
            for (i = 0; i < expectedList.size(); ++i) {
                if (((String)expectedList.get(i)).equals(visitList.get(i))) continue;
                status = false;
                this.log.info("visitList.get(" + i + ") incorrect: should be: " + (String)expectedList.get(i) + ", is: " + visitList.get(i));
                break;
            }
        }
        if (!status) {
            this.log.info("\rexpectedList: ");
            for (i = 0; i < expectedList.size(); ++i) {
                this.log.info(i + ": " + ((String)expectedList.get(i)).toString());
            }
            this.log.info("\rvisitList:");
            for (i = 0; i < visitList.size(); ++i) {
                this.log.info(i + ": " + visitList.get(i).toString());
            }
        }
        return status ? Response.ok().build() : Response.serverError().build();
    }
}

