/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.injection.reverse;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateful;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jboss.resteasy.cdi.injection.Book;
import org.jboss.resteasy.cdi.injection.BookResource;
import org.jboss.resteasy.cdi.injection.reverse.EJBHolderLocal;
import org.jboss.resteasy.cdi.injection.reverse.EJBHolderRemote;
import org.jboss.resteasy.cdi.injection.reverse.StatefulApplicationScopedEJBwithJaxRsComponents;
import org.jboss.resteasy.cdi.injection.reverse.StatefulApplicationScopedEJBwithJaxRsComponentsInterface;
import org.jboss.resteasy.cdi.injection.reverse.StatefulDependentScopedEJBwithJaxRsComponents;
import org.jboss.resteasy.cdi.injection.reverse.StatefulDependentScopedEJBwithJaxRsComponentsInterface;
import org.jboss.resteasy.cdi.injection.reverse.StatefulRequestScopedEJBwithJaxRsComponents;
import org.jboss.resteasy.cdi.injection.reverse.StatefulRequestScopedEJBwithJaxRsComponentsInterface;
import org.jboss.resteasy.cdi.injection.reverse.StatelessEJBwithJaxRsComponents;
import org.jboss.resteasy.cdi.injection.reverse.StatelessEJBwithJaxRsComponentsInterface;
import org.jboss.resteasy.cdi.util.Utilities;

@Stateful
@RequestScoped
public class EJBHolder
implements EJBHolderRemote,
EJBHolderLocal {
    public static final String SLE = "sle";
    public static final String SFDE = "sfde";
    public static final String SFRE = "sfre";
    public static final String SFAE = "sfae";
    public static final String SLI = "sli";
    public static final String SFDI = "sfdi";
    public static final String SFRI = "sfri";
    public static final String SFAI = "sfai";
    public static final String SLI_SECRET = "sliSecret";
    public static final String SFDI_SECRET = "sfdiSecret";
    public static final String SFRI_SECRET = "sfriSecret";
    public static final String SFAI_SECRET = "sfaiSecret";
    private static HashMap<String, Object> store = new HashMap();
    @Inject
    private Logger log;
    @Inject
    private Utilities utilities;
    @Inject
    int secret;
    @EJB
    private StatelessEJBwithJaxRsComponentsInterface sle;
    @EJB
    private StatefulDependentScopedEJBwithJaxRsComponentsInterface sfde;
    @EJB
    private StatefulRequestScopedEJBwithJaxRsComponentsInterface sfre;
    @EJB
    private StatefulApplicationScopedEJBwithJaxRsComponentsInterface sfae;
    @Inject
    private StatelessEJBwithJaxRsComponentsInterface sli;
    @Inject
    private StatefulDependentScopedEJBwithJaxRsComponentsInterface sfdi;
    @Inject
    private StatefulRequestScopedEJBwithJaxRsComponentsInterface sfri;
    @Inject
    private StatefulApplicationScopedEJBwithJaxRsComponentsInterface sfai;
    @Inject
    private BookResource resource;

    @PostConstruct
    public void postConstruct() {
        this.log.info(this + " secret: " + this.secret);
    }

    @Override
    public boolean testScopes() {
        this.log.info("");
        this.log.info("entering EJBHolder.testScopes()");
        this.log.info("resource scope:                                                 " + this.utilities.getScope(BookResource.class));
        this.log.info("EJBHolder scope:                                                " + this.utilities.getScope(EJBHolder.class));
        this.log.info("EJBHolderLocal scope:                                           " + this.utilities.getScope(EJBHolderLocal.class));
        this.log.info("EJBHolderRemote scope:                                          " + this.utilities.getScope(EJBHolderRemote.class));
        this.log.info("StatelessEJBwithJaxRsComponents scope:                          " + this.utilities.getScope(StatelessEJBwithJaxRsComponents.class));
        this.log.info("StatelessEJBwithJaxRsComponentsInterface scope:                 " + this.utilities.getScope(StatelessEJBwithJaxRsComponentsInterface.class));
        this.log.info("StatefulDependentScopedEJBwithJaxRsComponents scope:            " + this.utilities.getScope(StatefulDependentScopedEJBwithJaxRsComponents.class));
        this.log.info("StatefulDependentScopedEJBwithJaxRsComponentsInterface scope:   " + this.utilities.getScope(StatefulDependentScopedEJBwithJaxRsComponentsInterface.class));
        this.log.info("StatefulRequestScopedEJBwithJaxRsComponents scope:              " + this.utilities.getScope(StatefulRequestScopedEJBwithJaxRsComponents.class));
        this.log.info("StatefulRequestScopedEJBwithJaxRsComponentsInterface scope:     " + this.utilities.getScope(StatefulRequestScopedEJBwithJaxRsComponentsInterface.class));
        this.log.info("StatefulApplicationScopedEJBwithJaxRsComponents scope:          " + this.utilities.getScope(StatefulApplicationScopedEJBwithJaxRsComponents.class));
        this.log.info("StatefulApplicationScopedEJBwithJaxRsComponentsInterface scope: " + this.utilities.getScope(StatefulApplicationScopedEJBwithJaxRsComponentsInterface.class));
        return this.utilities.isDependentScoped(StatelessEJBwithJaxRsComponentsInterface.class) && this.utilities.isDependentScoped(StatefulDependentScopedEJBwithJaxRsComponentsInterface.class) && this.utilities.isRequestScoped(StatefulRequestScopedEJBwithJaxRsComponentsInterface.class) && this.utilities.isApplicationScoped(StatefulApplicationScopedEJBwithJaxRsComponentsInterface.class);
    }

    @Override
    public void setup() {
        this.log.info("");
        this.log.info("entering EJBHolder.setup()");
        this.resource.getSet().add(new Book("Disappearing Book"));
        store.put(SLE, this.sle);
        store.put(SFDE, this.sfde);
        store.put(SFRE, this.sfre);
        store.put(SFAE, this.sfae);
        store.put(SLI, this.sli);
        store.put(SFDI, this.sfdi);
        store.put(SFRI, this.sfri);
        store.put(SFAI, this.sfai);
        store.put("sli.secret", this.sli.theSecret());
        store.put("sfdi.secret", this.sfdi.theSecret());
        store.put("sfri.secret", this.sfri.theSecret());
        store.put("sfai.secret", this.sfai.theSecret());
        this.sleSetup();
        this.sfdeSetup();
        this.sfreSetup();
        this.sfaeSetup();
        this.sliSetup();
        this.sfdiSetup();
        this.sfriSetup();
        this.sfaiSetup();
    }

    @Override
    public boolean test() {
        this.log.info("");
        this.log.info("entering EJBHolder.test()");
        boolean result = true;
        result &= this.resource.getSet().isEmpty();
        result &= store.get(SLE).equals(this.sle);
        result &= !store.get(SFDE).equals(this.sfde);
        result &= !store.get(SFRE).equals(this.sfre);
        result &= !store.get(SFAE).equals(this.sfae);
        result &= store.get(SLE) != this.sle;
        result &= store.get(SFDE) != this.sfde;
        result &= store.get(SFRE) != this.sfre;
        result &= store.get(SFAE) != this.sfae;
        this.log.info("sli:  == stored sli:  " + (this.sli == store.get(SLI)));
        this.log.info("sfdi: == stored sfdi: " + (this.sfdi == store.get(SFDI)));
        this.log.info("sfri: == stored sfri: " + (this.sfri == store.get(SFRI)));
        this.log.info("sfai: == stored sfai: " + (this.sfai == store.get(SFAI)));
        this.log.info("sli.secret:  == stored sli.secret:  " + (this.sli.theSecret() == ((Integer)Integer.class.cast(store.get("sli.secret"))).intValue()));
        this.log.info("sfdi.secret: == stored sfdi.secret: " + (this.sfdi.theSecret() == ((Integer)Integer.class.cast(store.get("sfdi.secret"))).intValue()));
        this.log.info("sfri.secret: == stored sfri.secret: " + (this.sfri.theSecret() == ((Integer)Integer.class.cast(store.get("sfri.secret"))).intValue()));
        this.log.info("sfai.secret: == stored sfai.secret: " + (this.sfai.theSecret() == ((Integer)Integer.class.cast(store.get("sfai.secret"))).intValue()));
        result &= this.sli != store.get(SLI);
        result &= this.sfdi.theSecret() != ((Integer)Integer.class.cast(store.get("sfdi.secret"))).intValue();
        result &= this.sfri.theSecret() != ((Integer)Integer.class.cast(store.get("sfri.secret"))).intValue();
        result &= this.sfai == store.get(SFAI) && this.sfai.theSecret() == ((Integer)Integer.class.cast(store.get("sfai.secret"))).intValue();
        result &= this.sleTest();
        result &= this.sfdeTest();
        result &= this.sfreTest();
        result &= this.sfaeTest();
        result &= this.sliTest();
        result &= this.sfdiTest();
        result &= this.sfriTest();
        return result &= this.sfaiTest();
    }

    @Override
    public void sleSetup() {
        this.sle.setUp(SLE);
    }

    @Override
    public boolean sleTest() {
        return this.sle.test(SLE);
    }

    @Override
    public void sfdeSetup() {
        this.sfde.setUp(SFDE);
    }

    @Override
    public boolean sfdeTest() {
        return this.sfde.test(SFDE);
    }

    @Override
    public void sfreSetup() {
        this.sfre.setUp(SFRE);
    }

    @Override
    public boolean sfreTest() {
        return this.sfre.test(SFRE);
    }

    @Override
    public void sfaeSetup() {
        this.sfae.setUp(SFAE);
    }

    @Override
    public boolean sfaeTest() {
        return this.sfae.test(SFAE);
    }

    @Override
    public void sliSetup() {
        this.sli.setUp(SLI);
    }

    @Override
    public boolean sliTest() {
        return this.sli.test(SLI);
    }

    @Override
    public void sfdiSetup() {
        this.sfdi.setUp(SFDI);
    }

    @Override
    public boolean sfdiTest() {
        return this.sfdi.test(SFDI);
    }

    @Override
    public void sfriSetup() {
        this.sfri.setUp(SFRI);
    }

    @Override
    public boolean sfriTest() {
        return this.sfri.test(SFRI);
    }

    @Override
    public void sfaiSetup() {
        this.sfai.setUp(SFAI);
    }

    @Override
    public boolean sfaiTest() {
        return this.sfai.test(SFAI);
    }

    @Override
    public boolean theSame(EJBHolderLocal that) {
        this.log.info("this secret: " + this.secret);
        this.log.info("that secret: " + that.theSecret());
        return this.secret == that.theSecret();
    }

    @Override
    public int theSecret() {
        return this.secret;
    }
}

