/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.injection.reverse;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateful;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.resteasy.cdi.injection.BookReader;
import org.jboss.resteasy.cdi.injection.BookResource;
import org.jboss.resteasy.cdi.injection.BookWriter;
import org.jboss.resteasy.cdi.injection.reverse.EJBInterface;
import org.jboss.resteasy.cdi.injection.reverse.StatefulApplicationScopedEJBwithJaxRsComponentsInterface;

@Stateful
@ApplicationScoped
public class StatefulApplicationScopedEJBwithJaxRsComponents
implements StatefulApplicationScopedEJBwithJaxRsComponentsInterface {
    private static HashMap<String, HashMap<String, Object>> store = new HashMap();
    private static int constructions;
    private static int destructions;
    @Inject
    int secret;
    @Inject
    private Logger log;
    @Inject
    private BookResource resource;
    @Inject
    private BookReader reader;
    @Inject
    private BookWriter writer;

    public static int getConstructions() {
        return constructions;
    }

    public static int getDestructions() {
        return destructions;
    }

    @PostConstruct
    public void postConstruct() {
        ++constructions;
        this.log.info(this + " secret: " + this.secret);
    }

    @PreDestroy
    public void preDestroy() {
        ++destructions;
    }

    @Override
    public void setUp(String key) {
        this.log.info("entering StatefulApplicationScopedEJBwithJaxRsComponents.setUp()");
        HashMap<String, Object> substore = new HashMap<String, Object>();
        substore.put("secret", this.resource.theSecret());
        substore.put("BookReader", this.reader);
        substore.put("BookWriter", this.writer);
        store.put(key, substore);
    }

    @Override
    public boolean test(String key) {
        this.log.info("entering StatefulApplicationScopedEJBwithJaxRsComponents.test(" + key + ")");
        HashMap<String, Object> substore = store.get(key);
        int savedSecret = (Integer)Integer.class.cast(substore.get("secret"));
        this.log.info("stored resource secret = resource secret: " + (savedSecret == this.resource.theSecret()));
        this.log.info("stored reader = reader:                   " + (substore.get("BookReader") == this.reader));
        this.log.info("stored writer = writer:                   " + (substore.get("BookWriter") == this.writer));
        boolean result = true;
        result &= this.reader == substore.get("BookReader");
        result &= this.writer == substore.get("BookWriter");
        result = "non-contextual".equals(key) ? (result &= this.resource.theSecret() == savedSecret) : (result &= this.resource.theSecret() != savedSecret);
        return result;
    }

    @Override
    public Class<?> theClass() {
        return StatefulApplicationScopedEJBwithJaxRsComponents.class;
    }

    @Override
    public boolean theSame(EJBInterface ejb) {
        if (ejb == null) {
            return false;
        }
        Class<?> c = ejb.theClass();
        if (!StatefulApplicationScopedEJBwithJaxRsComponents.class.equals(c)) {
            this.log.info(ejb + " not instanceof StatefulApplicationScopedEJBwithJaxRsComponents: " + c);
            return false;
        }
        this.log.info(this.secret + " " + ejb.theSecret());
        return this.secret == ejb.theSecret();
    }

    @Override
    public int theSecret() {
        return this.secret;
    }
}

