/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Scope;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.JaxrsAnnotatedType;
import org.jboss.resteasy.cdi.JaxrsInjectionTarget;
import org.jboss.resteasy.cdi.ResteasyCdiConfiguration;
import org.jboss.resteasy.util.GetRestful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap
implements Extension {
    private final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    public static final Annotation requestScopedLiteral = new AnnotationLiteral<RequestScoped>(){
        private static final long serialVersionUID = 3381824686081435817L;
    };
    public static final Annotation applicationScopedLiteral = new AnnotationLiteral<ApplicationScoped>(){
        private static final long serialVersionUID = -8211157243671012820L;
    };
    private Map<Class<?>, Class<?>> sessionBeanInterface = new HashMap();

    public <T> void observeResources(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (!type.getJavaClass().isInterface()) {
            if (type.isAnnotationPresent(Provider.class)) {
                this.log.debug("Discovered CDI bean which is a JAX-RS provider {}.", (Object)type.getJavaClass().getCanonicalName());
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            } else if (GetRestful.isRootResource((Class)type.getJavaClass())) {
                this.log.debug("Discovered CDI bean which is a JAX-RS resource {}.", (Object)type.getJavaClass().getCanonicalName());
                event.setAnnotatedType(this.wrapAnnotatedType(type, requestScopedLiteral));
            } else if (Application.class.isAssignableFrom(type.getJavaClass())) {
                this.log.debug("Discovered CDI bean which is javax.ws.rs.core.Application subclass {}.", (Object)type.getJavaClass().getCanonicalName());
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            }
        }
    }

    protected <T> AnnotatedType<T> wrapAnnotatedType(AnnotatedType<T> type, Annotation scope) {
        if (this.hasScopeDefined(type.getJavaClass())) {
            this.log.debug("Bean {} has a scope defined.", (Object)type.getJavaClass());
            return type;
        }
        this.log.debug("Bean {} does not have the scope defined. Binding to {}.", (Object)type.getJavaClass(), (Object)scope);
        return new JaxrsAnnotatedType<T>(type, scope);
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        if (event.getAnnotatedType() == null) {
            this.log.warn("ProcessInjectionTarget.getAnnotatedType() returned null. As a result, JAX-RS property injection will not work.");
            return;
        }
        if (this.isJaxrsComponent(event.getAnnotatedType().getJavaClass())) {
            event.setInjectionTarget(this.wrapInjectionTarget(event));
        }
    }

    protected <T> InjectionTarget<T> wrapInjectionTarget(ProcessInjectionTarget<T> event) {
        return new JaxrsInjectionTarget(event.getInjectionTarget(), event.getAnnotatedType().getJavaClass());
    }

    public <T> void observeSessionBeans(@Observes ProcessSessionBean<T> event) {
        Bean sessionBean = event.getBean();
        if (this.isJaxrsComponent(sessionBean.getBeanClass())) {
            this.addSessionBeanInterface(sessionBean);
        }
    }

    public void setResteasyCdiConfiguration(@Observes AfterBeanDiscovery event, BeanManager manager) {
        ResteasyCdiConfiguration configuration = Bootstrap.lookupResteasyCdiConfiguration(manager);
        configuration.setSessionBeanInterfaceMap(this.sessionBeanInterface);
    }

    private void addSessionBeanInterface(Bean<?> bean) {
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !((Class)type).isInterface()) continue;
            this.sessionBeanInterface.put(bean.getBeanClass(), (Class)type);
            break;
        }
    }

    private boolean isJaxrsComponent(Class<?> clazz) {
        Provider providerAnnotation = clazz.getAnnotation(Provider.class);
        return providerAnnotation != null || GetRestful.isRootResource(clazz) || Application.class.isAssignableFrom(clazz);
    }

    public boolean hasScopeDefined(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (this.isScope(annotation)) {
                return true;
            }
            if (!this.isStereotype(annotation) || !this.hasScopeDefined(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private boolean isScope(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.isAnnotationPresent(NormalScope.class) || annotationType.isAnnotationPresent(Scope.class);
    }

    private boolean isStereotype(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Stereotype.class);
    }

    public static ResteasyCdiConfiguration lookupResteasyCdiConfiguration(BeanManager manager) {
        Set beans = manager.getBeans(ResteasyCdiConfiguration.class, new Annotation[0]);
        Bean bean = manager.resolve(beans);
        CreationalContext context = manager.createCreationalContext((Contextual)bean);
        return (ResteasyCdiConfiguration)manager.getReference(bean, ResteasyCdiConfiguration.class, context);
    }
}

