/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Stereotype;
import javax.inject.Scope;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static boolean isJaxrsAnnotatedClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJaxrsResource(Class<?> clazz) {
        if (Utils.isJaxrsAnnotatedClass(clazz)) {
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!Utils.isJaxrsAnnotatedClass(intf)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJaxrsComponent(Class<?> clazz) {
        return clazz.isAnnotationPresent(Provider.class) || Utils.isJaxrsResource(clazz) || Application.class.isAssignableFrom(clazz);
    }

    public static boolean isScopeDefined(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (Utils.isScope(annotation)) {
                return true;
            }
            if (!Utils.isStereotype(annotation) || !Utils.isScopeDefined(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isScope(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.isAnnotationPresent(NormalScope.class) || annotationType.isAnnotationPresent(Scope.class);
    }

    private static boolean isStereotype(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Stereotype.class);
    }
}

