/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.ToIntFunction;
import org.eclipse.jetty.util.Callback;

class JettyResponseStream
extends InputStream {
    private final Deque<Chunk> chunks = new LinkedList<Chunk>();
    private Chunk readTop;
    private volatile boolean closed;

    JettyResponseStream() {
    }

    void offer(ByteBuffer content, Callback callback) {
        if (this.closed) {
            IllegalStateException x = new IllegalStateException("closed");
            callback.failed((Throwable)x);
            throw x;
        }
        this.chunks.add(new Chunk(content, callback));
    }

    @Override
    public int read() throws IOException {
        return this.read0(chunk -> chunk.buf.get());
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read0(chunk -> {
            int r = Math.min(chunk.buf.remaining(), len);
            chunk.buf.get(b, off, r);
            return r;
        });
    }

    private int read0(ToIntFunction<Chunk> reader) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.readTop == null) {
            this.readTop = this.chunks.pollFirst();
        }
        if (this.readTop == null || this.closed) {
            return -1;
        }
        int result = reader.applyAsInt(this.readTop);
        if (!this.readTop.buf.hasRemaining()) {
            this.readTop.callback.succeeded();
            this.readTop = null;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.readTop != null) {
            this.readTop.callback.succeeded();
            this.readTop = null;
        }
        this.chunks.removeIf(c -> {
            c.callback.succeeded();
            return true;
        });
    }

    static class Chunk {
        final ByteBuffer buf;
        final Callback callback;

        Chunk(ByteBuffer buf, Callback callback) {
            this.buf = buf;
            this.callback = callback;
        }
    }
}

