/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.interception.ClientReaderInterceptorContext;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.Types;

public abstract class ClientResponse
extends BuiltResponse {
    private static final Logger logger = Logger.getLogger(ClientResponse.class);
    protected Map<String, Object> properties;
    protected ClientConfiguration configuration;
    protected byte[] bufferedEntity;

    protected ClientResponse(ClientConfiguration configuration) {
        this.setClientConfiguration(configuration);
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.metadata = new Headers();
        this.metadata.putAll(headers);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setClientConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.processor = configuration;
    }

    public Object getEntity() {
        this.abortIfClosed();
        return super.getEntity();
    }

    public boolean hasEntity() {
        this.abortIfClosed();
        return this.getInputStream() != null && (this.entity != null || this.getMediaType() != null);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.isClosed = true;
            this.releaseConnection();
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.isClosed()) {
            return;
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected HeaderValueProcessor getHeaderValueProcessor() {
        return this.configuration;
    }

    protected abstract InputStream getInputStream();

    protected InputStream getEntityStream() {
        if (this.bufferedEntity != null) {
            return new ByteArrayInputStream(this.bufferedEntity);
        }
        if (this.isClosed()) {
            throw new ProcessingException("Stream is closed");
        }
        return this.getInputStream();
    }

    protected abstract void setInputStream(InputStream var1);

    protected abstract void releaseConnection() throws IOException;

    public <T> T readEntity(Class<T> type, Type genericType, Annotation[] anns) {
        this.abortIfClosed();
        if (this.entity != null) {
            if (type.isInstance(this.entity)) {
                return (T)this.entity;
            }
            if (this.entity instanceof InputStream) {
                this.setInputStream((InputStream)this.entity);
                this.entity = null;
            } else {
                if (this.bufferedEntity == null) {
                    throw new RuntimeException("The entity was already read, and it was of type " + this.entity.getClass());
                }
                this.entity = null;
            }
        }
        if (this.entity == null) {
            if (this.status == 204) {
                return null;
            }
            try {
                this.entity = this.readFrom(type, genericType, this.getMediaType(), anns);
                if (this.entity == null || this.entity != null && !InputStream.class.isInstance(this.entity) && !Reader.class.isInstance(this.entity) && this.bufferedEntity == null) {
                    try {
                        this.close();
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (RuntimeException e) {
                try {
                    this.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw e;
            }
        }
        return (T)this.entity;
    }

    protected <T> Object readFrom(Class<T> type, Type genericType, MediaType media, Annotation[] annotations) {
        Type useGeneric = genericType == null ? type : genericType;
        Class useType = type;
        media = media == null ? MediaType.WILDCARD_TYPE : media;
        annotations = annotations == null ? this.annotations : annotations;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)this.configuration);
        try {
            InputStream is = this.getEntityStream();
            if (is == null) {
                throw new IllegalStateException("Input stream was empty, there is no entity");
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            ReaderInterceptor[] readerInterceptors = this.configuration.getReaderInterceptors(null, null);
            final Object obj = new ClientReaderInterceptorContext(readerInterceptors, this.configuration.getProviderFactory(), useType, useGeneric, annotations, media, this.getStringHeaders(), is, this.properties).proceed();
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                MarshalledEntity marshalledEntity = new MarshalledEntity(){

                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    public Object getEntity() {
                        return obj;
                    }
                };
                return marshalledEntity;
            }
            Object object = obj;
            return object;
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
            }
        }
    }

    public boolean bufferEntity() {
        this.abortIfClosed();
        if (this.bufferedEntity != null) {
            return true;
        }
        if (this.entity != null) {
            return false;
        }
        if (this.metadata.getFirst("Content-Type") == null) {
            return false;
        }
        try {
            this.bufferedEntity = ReadFromStream.readFromStream((int)1024, (InputStream)this.getInputStream());
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                this.releaseConnection();
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        return true;
    }
}

