/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.cache.BrowserCache;
import org.jboss.resteasy.client.jaxrs.cache.CacheEntry;

public class MapCache
implements BrowserCache {
    protected Map<String, Map<String, BrowserCache.Entry>> cache = null;

    public MapCache() {
        this(new ConcurrentHashMap<String, Map<String, BrowserCache.Entry>>());
    }

    public MapCache(Map<String, Map<String, BrowserCache.Entry>> cache) {
        this.cache = cache;
    }

    protected Map<String, Map<String, BrowserCache.Entry>> createCache() {
        return new ConcurrentHashMap<String, Map<String, BrowserCache.Entry>>();
    }

    @Override
    public BrowserCache.Entry get(String key, MediaType accept) {
        Map<String, BrowserCache.Entry> parent = this.cache.get(key);
        if (parent == null || parent.isEmpty()) {
            return null;
        }
        if (accept.isWildcardType()) {
            return parent.entrySet().iterator().next().getValue();
        }
        if (accept.isWildcardSubtype()) {
            for (Map.Entry<String, BrowserCache.Entry> parentEntry : parent.entrySet()) {
                if (!parentEntry.getKey().startsWith(String.valueOf(accept.getType()) + "/")) continue;
                return parentEntry.getValue();
            }
        }
        return parent.get(accept.toString());
    }

    @Override
    public BrowserCache.Entry getAny(String key) {
        Map<String, BrowserCache.Entry> parent = this.cache.get(key);
        if (parent == null) {
            return null;
        }
        Iterator<BrowserCache.Entry> iterator = parent.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public BrowserCache.Entry getEntry(String key, MediaType accept) {
        Map<String, BrowserCache.Entry> parent = this.cache.get(key);
        if (parent == null) {
            return null;
        }
        return parent.get(accept.toString());
    }

    @Override
    public BrowserCache.Entry remove(String key, MediaType type) {
        Map<String, BrowserCache.Entry> data = this.cache.get(key);
        if (data == null) {
            return null;
        }
        BrowserCache.Entry removed = data.remove(type.toString());
        if (data.isEmpty()) {
            this.cache.remove(key);
        } else {
            this.cache.put(key, data);
        }
        return removed;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public BrowserCache.Entry put(CacheEntry cacheEntry) {
        Map<String, BrowserCache.Entry> map = this.cache.get(cacheEntry.getKey());
        if (map == null) {
            map = new ConcurrentHashMap<String, BrowserCache.Entry>();
        }
        map.put(cacheEntry.getMediaType().toString(), cacheEntry);
        this.cache.put(cacheEntry.getKey(), map);
        return cacheEntry;
    }

    @Override
    public BrowserCache.Entry put(String key, MediaType mediaType, MultivaluedMap<String, String> headers, byte[] cached, int expires, String etag, String lastModified) {
        return this.put(new CacheEntry(key, headers, cached, expires, etag, lastModified, mediaType));
    }
}

