/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.unlogic.standardutils.xml.XMLable;

public class XMLUtils {
    private static DocumentBuilder documentBuilder;
    private static DocumentBuilder namespaceAwareDocumentBuilder;
    private static final Logger logger;

    public static Document createDomDocument() {
        return documentBuilder.newDocument();
    }

    public static Document createNamespaceAwareDomDocument() {
        return namespaceAwareDocumentBuilder.newDocument();
    }

    public static String toString(Document doc, String encoding, boolean indent) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("encoding", encoding);
        if (indent) {
            xformer.setOutputProperty("indent", "yes");
        }
        xformer.transform(source, result);
        return sw.getBuffer().toString();
    }

    public static void toString(Document doc, String encoding, Writer w, boolean indent) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(w);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("encoding", encoding);
        if (indent) {
            xformer.setOutputProperty("indent", "yes");
        }
        xformer.transform(source, result);
    }

    public static Document parseXmlFile(String filename, boolean validating, boolean namespaceAware) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtils.parseXmlFile(new File(filename), validating, namespaceAware);
    }

    public static Document parseXmlFile(File file, boolean validating, boolean namespaceAware) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        Document doc = factory.newDocumentBuilder().parse(file);
        return doc;
    }

    public static Document parseXmlFile(URI uri, boolean validating) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        Document doc = factory.newDocumentBuilder().parse(uri.toString());
        return doc;
    }

    public static Document parseXmlFile(File f, boolean validating) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        Document doc = factory.newDocumentBuilder().parse(f);
        return doc;
    }

    public static Document parseXmlFile(InputStream stream, boolean validating) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        Document doc = factory.newDocumentBuilder().parse(stream);
        return doc;
    }

    public static Element createElement(String name, Object value, Document doc) {
        Element element = doc.createElement(name);
        element.appendChild(doc.createTextNode(value.toString()));
        return element;
    }

    public static Element createCDATAElement(String name, Object value, Document doc) {
        Element element = doc.createElement(name);
        element.appendChild(doc.createCDATASection(value.toString()));
        return element;
    }

    public static void writeXmlFile(Document doc, File file, boolean indent, String encoding) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("encoding", encoding);
        if (indent) {
            xformer.setOutputProperty("indent", "yes");
        }
        xformer.transform(source, result);
    }

    public static void writeXmlFile(Document doc, File file, Map.Entry<String, String> ... outputKeys) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        if (outputKeys != null) {
            for (Map.Entry<String, String> entry : outputKeys) {
                xformer.setOutputProperty(entry.getKey(), entry.getValue());
            }
        }
        xformer.transform(source, result);
    }

    public static void writeXmlFile(Document doc, String filename, boolean indent, String encoding) throws TransformerFactoryConfigurationError, TransformerException {
        File file = new File(filename);
        XMLUtils.writeXmlFile(doc, file, indent, encoding);
    }

    public static void append(Document doc, Element targetElement, Collection<? extends XMLable> beans) {
        if (beans != null && !beans.isEmpty()) {
            for (XMLable xMLable : beans) {
                targetElement.appendChild(xMLable.toXML(doc));
            }
        }
    }

    public static void append(Document doc, Element targetElement, String elementName, String subElementsName, Object[] values) {
        if (values != null) {
            Element subElement = doc.createElement(elementName);
            targetElement.appendChild(subElement);
            for (Object value : values) {
                XMLUtils.appendNewCDATAElement(doc, subElement, subElementsName, value);
            }
        }
    }

    public static void append(Document doc, Element targetElement, String elementName, String subElementsName, List<? extends Object> values) {
        if (values != null) {
            Element subElement = doc.createElement(elementName);
            targetElement.appendChild(subElement);
            for (Object object : values) {
                XMLUtils.appendNewCDATAElement(doc, subElement, subElementsName, object);
            }
        }
    }

    public static void append(Document doc, Element targetElement, String elementName, Collection<? extends XMLable> beans) {
        if (beans != null && !beans.isEmpty()) {
            Element subElement = doc.createElement(elementName);
            targetElement.appendChild(subElement);
            for (XMLable xMLable : beans) {
                subElement.appendChild(xMLable.toXML(doc));
            }
        }
    }

    public static void appendNewCDATAElement(Document doc, Element targetElement, String elementName, String value) {
        if (value != null) {
            targetElement.appendChild(XMLUtils.createCDATAElement(elementName, value, doc));
        }
    }

    public static void appendNewElement(Document doc, Element targetElement, String elementName, String value) {
        if (value != null) {
            targetElement.appendChild(XMLUtils.createElement(elementName, value, doc));
        }
    }

    public static void appendNewCDATAElement(Document doc, Element targetElement, String elementName, Object value) {
        if (value != null) {
            XMLUtils.appendNewCDATAElement(doc, targetElement, elementName, value.toString());
        }
    }

    public static void appendNewElement(Document doc, Element targetElement, String elementName, Object value) {
        if (value != null) {
            XMLUtils.appendNewElement(doc, targetElement, elementName, value.toString());
        }
    }

    public static void replaceSingleNode(Element parent, Node node) throws RuntimeException {
        NodeList nodes = parent.getElementsByTagName(node.getNodeName());
        if (nodes.getLength() > 1) {
            throw new RuntimeException("Parent element contains multiple nodes with the name " + node.getNodeName());
        }
        if (nodes.getLength() == 0) {
            parent.appendChild(node);
        } else {
            parent.replaceChild(node, nodes.item(0));
        }
    }

    public static Element getTimeUnits(Document doc, TimeUnit timeUnit) {
        switch (timeUnit) {
            case HOUR: {
                Element hourElement;
                int i;
                Element hoursElement = doc.createElement("hours");
                for (i = 0; i < 10; ++i) {
                    hourElement = doc.createElement("hour");
                    XMLUtils.appendNewElement(doc, hourElement, "value", "0" + i);
                    hoursElement.appendChild(hourElement);
                }
                for (i = 10; i < 24; ++i) {
                    hourElement = doc.createElement("hour");
                    XMLUtils.appendNewElement(doc, hourElement, "value", i);
                    hoursElement.appendChild(hourElement);
                }
                return hoursElement;
            }
            case MINUTE: {
                Element minuteElement;
                int i;
                Element minutesElement = doc.createElement("minutes");
                for (i = 0; i < 10; ++i) {
                    minuteElement = doc.createElement("minute");
                    XMLUtils.appendNewElement(doc, minuteElement, "value", "0" + i);
                    minutesElement.appendChild(minuteElement);
                }
                for (i = 10; i < 60; ++i) {
                    minuteElement = doc.createElement("minute");
                    XMLUtils.appendNewElement(doc, minuteElement, "value", i);
                    minutesElement.appendChild(minuteElement);
                }
                return minutesElement;
            }
            case SECOND: {
                Element secondElement;
                int i;
                Element secondsElement = doc.createElement("seconds");
                for (i = 0; i < 10; ++i) {
                    secondElement = doc.createElement("second");
                    XMLUtils.appendNewElement(doc, secondElement, "value", "0" + i);
                    secondsElement.appendChild(secondElement);
                }
                for (i = 10; i < 60; ++i) {
                    secondElement = doc.createElement("second");
                    XMLUtils.appendNewElement(doc, secondElement, "value", i);
                    secondsElement.appendChild(secondElement);
                }
                return secondsElement;
            }
        }
        return null;
    }

    static {
        logger = Logger.getLogger(XMLUtils.class);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilderFactory.setNamespaceAware(true);
            namespaceAwareDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static enum TimeUnit {
        HOUR,
        MINUTE,
        SECOND;

    }
}

