/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.BeanStringPopulatorRegistery;
import se.unlogic.standardutils.populators.UnableToFindSuitablePopulatorException;
import se.unlogic.standardutils.reflection.MethodNotFoundException;
import se.unlogic.standardutils.string.StringUtils;

public class ReflectionUtils {
    public static Object getInstance(String className) throws NoClassDefFoundError, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Class.forName(className).newInstance();
    }

    public static boolean isGenericlyTyped(Field field) {
        return field.getGenericType() instanceof ParameterizedType;
    }

    public static int getGenericlyTypeCount(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            return type.getActualTypeArguments().length;
        }
        return 0;
    }

    public static int getGenericlyTypeCount(Method method) {
        return method.getGenericParameterTypes().length;
    }

    public static boolean checkGenericTypes(Field field, Class<?> ... classes) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            if (type.getActualTypeArguments().length != classes.length) {
                return false;
            }
            for (int i = 0; i < classes.length; ++i) {
                if (type.getActualTypeArguments()[i].equals(classes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Type getGenericType(Field field) {
        Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        return type;
    }

    public static Object getGenericType(Method method) {
        return method.getGenericParameterTypes()[0];
    }

    public static void fixFieldAccess(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public static void fixMethodAccess(Method method) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    public static Field getField(Class<?> bean, String fieldName) {
        List<Field> fields = ReflectionUtils.getFields(bean);
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new RuntimeException(new NoSuchFieldError(fieldName));
    }

    public static boolean isAvailable(String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (clazz = clazz.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    public static List<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        for (clazz = clazz.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return methods;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... inputParams) {
        Method[] methods;
        if (inputParams == null) {
            inputParams = new Class[]{};
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !returnType.isAssignableFrom(method.getReturnType()) || !Arrays.equals(inputParams, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public static void setFieldValue(Field field, Object value, Object target) throws IllegalArgumentException, IllegalAccessException {
        boolean declaredAccessible = field.isAccessible();
        if (!declaredAccessible) {
            field.setAccessible(true);
        }
        field.set(target, value);
        if (!declaredAccessible) {
            field.setAccessible(false);
        }
    }

    public static void setMethodValue(Method method, Object value, Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        boolean declaredAccessible = method.isAccessible();
        if (!declaredAccessible) {
            method.setAccessible(true);
        }
        method.invoke(target, value);
        if (!declaredAccessible) {
            method.setAccessible(false);
        }
    }

    public static boolean setSetterMethod(Object target, String methodName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MethodNotFoundException, UnableToFindSuitablePopulatorException {
        BeanStringPopulator<?> populator;
        Method method;
        if (!((String)methodName).startsWith("set")) {
            methodName = "set" + StringUtils.toFirstLetterUppercase((String)methodName);
        }
        if ((method = ReflectionUtils.getMethod(target.getClass(), (String)methodName, 1)) == null) {
            throw new MethodNotFoundException("Unable to find setter method " + (String)methodName + " with correct signature");
        }
        if (value == null || method.getParameterTypes()[0].equals(String.class)) {
            ReflectionUtils.setMethodValue(method, value, target);
        }
        if ((populator = BeanStringPopulatorRegistery.getBeanStringPopulator(method.getParameterTypes()[0])) == null) {
            throw new UnableToFindSuitablePopulatorException("Unable to find BeanStringPopulator for " + method.getParameterTypes()[0]);
        }
        ReflectionUtils.setMethodValue(method, populator.getValue(value), target);
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodName, int argumentCount) {
        List<Method> methods = ReflectionUtils.getMethods(clazz);
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(methodName) || method.getParameterCount() != argumentCount) continue;
            return method;
        }
        return null;
    }
}

