/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns.zoneproviders.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Zone;
import se.unlogic.eagledns.SecondaryZone;
import se.unlogic.eagledns.ZoneChangeCallback;
import se.unlogic.eagledns.ZoneProvider;
import se.unlogic.eagledns.ZoneProviderUpdatable;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.timer.RunnableTimerTask;

public class FileZoneProvider
implements ZoneProvider,
ZoneProviderUpdatable,
Runnable {
    private final Logger log = Logger.getLogger(this.getClass());
    private String name;
    private String zoneFileDirectory;
    private boolean autoReloadZones;
    private Long pollingInterval;
    private Map<String, Long> lastFileList = new HashMap<String, Long>();
    private ZoneChangeCallback changeCallback;
    private Timer watcher;

    @Override
    public void init(String name) {
        this.name = name;
        if (this.autoReloadZones && this.pollingInterval != null) {
            this.watcher = new Timer(true);
            this.watcher.schedule((TimerTask)new RunnableTimerTask(this), 5000L, (long)this.pollingInterval);
        }
    }

    @Override
    public void run() {
        if (this.changeCallback != null && this.hasDirectoryChanged()) {
            this.log.info((Object)("Changes in directory " + this.zoneFileDirectory + " detected"));
            this.changeCallback.zoneDataChanged();
        }
    }

    private boolean hasDirectoryChanged() {
        File folder = new File(this.zoneFileDirectory);
        File[] files = folder.listFiles();
        if (files.length != this.lastFileList.size()) {
            return true;
        }
        for (File f : folder.listFiles()) {
            if (!this.lastFileList.containsKey(f.getName())) {
                return true;
            }
            if (f.lastModified() <= this.lastFileList.get(f.getName())) continue;
            return true;
        }
        return false;
    }

    private void updateZoneFiles(File[] files) {
        this.lastFileList = new HashMap<String, Long>();
        for (File f : files) {
            this.lastFileList.put(f.getName(), f.lastModified());
        }
    }

    @Override
    public Collection<Zone> getPrimaryZones() {
        File zoneDir = new File(this.zoneFileDirectory);
        if (!zoneDir.exists() || !zoneDir.isDirectory()) {
            this.log.error((Object)("Zone file directory specified for FileZoneProvider " + this.name + " does not exist!"));
            return null;
        }
        if (!zoneDir.canRead()) {
            this.log.error((Object)("Zone file directory specified for FileZoneProvider " + this.name + " is not readable!"));
            return null;
        }
        File[] files = zoneDir.listFiles();
        this.updateZoneFiles(files);
        if (files == null || files.length == 0) {
            this.log.info((Object)("No zone files found for FileZoneProvider " + this.name + " in directory " + zoneDir.getPath()));
            return null;
        }
        ArrayList<Zone> zones = new ArrayList<Zone>(files.length);
        for (File zoneFile : files) {
            if (!zoneFile.canRead()) {
                this.log.error((Object)("FileZoneProvider " + this.name + " unable to access zone file " + zoneFile));
                continue;
            }
            try {
                Name origin = Name.fromString((String)zoneFile.getName(), (Name)Name.root);
                Zone zone = new Zone(origin, zoneFile.getPath());
                this.log.debug((Object)("FileZoneProvider " + this.name + " successfully parsed zone file " + zoneFile.getName()));
                zones.add(zone);
            }
            catch (TextParseException e) {
                this.log.error((Object)("FileZoneProvider " + this.name + " unable to parse zone file " + zoneFile.getName()), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to parse zone file " + zoneFile + " in FileZoneProvider " + this.name), (Throwable)e);
            }
        }
        if (!zones.isEmpty()) {
            return zones;
        }
        return null;
    }

    @Override
    public void unload() {
    }

    public String getZoneFileDirectory() {
        return this.zoneFileDirectory;
    }

    public void setZoneFileDirectory(String zoneFileDirectory) {
        this.zoneFileDirectory = zoneFileDirectory;
        this.log.debug((Object)("zoneFileDirectory set to " + zoneFileDirectory));
    }

    @Override
    public Collection<SecondaryZone> getSecondaryZones() {
        return null;
    }

    @Override
    public void zoneUpdated(SecondaryZone secondaryZone) {
    }

    @Override
    public void zoneChecked(SecondaryZone secondaryZone) {
    }

    @Override
    public void setChangeListener(ZoneChangeCallback ev) {
        this.changeCallback = ev;
    }

    public void setAutoReloadZones(String autoReloadZones) {
        this.autoReloadZones = Boolean.parseBoolean(autoReloadZones);
    }

    public void setPollingInterval(String pollingInterval) {
        Long value = NumberUtils.toLong(pollingInterval);
        if (value != null && value > 0L) {
            this.pollingInterval = value;
        } else {
            this.log.warn((Object)("Invalid polling interval specified: " + pollingInterval));
        }
    }
}

