/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.collections.StrictMap;

public class StrictTreeMap<Key, Value>
implements StrictMap<Key, Value> {
    protected final TreeMap<Key, Value> treeMap;

    public StrictTreeMap(Comparator<Key> comparator) {
        this.treeMap = new TreeMap(comparator);
    }

    @Override
    public Value put(Key key, Value value) throws KeyAlreadyCachedException {
        if (this.treeMap.containsKey(key)) {
            throw new KeyAlreadyCachedException(key);
        }
        return this.treeMap.put(key, value);
    }

    @Override
    public Value update(Key key, Value value) throws KeyNotCachedException {
        if (this.treeMap.containsKey(key)) {
            this.treeMap.remove(key);
            return this.treeMap.put(key, value);
        }
        throw new KeyNotCachedException(key);
    }

    @Override
    public Value remove(Object key) throws KeyNotCachedException {
        if (this.treeMap.containsKey(key)) {
            return this.treeMap.remove(key);
        }
        throw new KeyNotCachedException(key);
    }

    @Override
    public void clear() {
        this.treeMap.clear();
    }

    public Object clone() {
        return this.treeMap.clone();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.treeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.treeMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return this.treeMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.treeMap.equals(o);
    }

    @Override
    public Value get(Object key) {
        return this.treeMap.get(key);
    }

    @Override
    public int hashCode() {
        return this.treeMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.treeMap.isEmpty();
    }

    @Override
    public Set<Key> keySet() {
        return this.treeMap.keySet();
    }

    @Override
    public int size() {
        return this.treeMap.size();
    }

    public String toString() {
        return this.treeMap.toString();
    }

    @Override
    public Collection<Value> values() {
        return this.treeMap.values();
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> map) throws KeyAlreadyCachedException {
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            if (!this.treeMap.containsKey(entry.getKey())) continue;
            throw new KeyAlreadyCachedException(entry.getKey());
        }
        this.treeMap.putAll(map);
    }
}

