/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import java.util.ArrayList;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.guice.GuiceResourceFactory;
import org.jboss.resteasy.plugins.guice.i18n.LogMessages;
import org.jboss.resteasy.plugins.guice.i18n.Messages;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

public class ModuleProcessor {
    private final Registry registry;
    private final ResteasyProviderFactory providerFactory;

    public ModuleProcessor(Registry registry, ResteasyProviderFactory providerFactory) {
        this.registry = registry;
        this.providerFactory = providerFactory;
    }

    public void processInjector(Injector injector) {
        ArrayList<Binding> rootResourceBindings = new ArrayList<Binding>();
        for (Binding binding : injector.getBindings().values()) {
            Class type = binding.getKey().getTypeLiteral().getRawType();
            if (!(type instanceof Class)) continue;
            Class beanClass = type;
            if (GetRestful.isRootResource((Class)beanClass)) {
                rootResourceBindings.add(binding);
            }
            if (!beanClass.isAnnotationPresent(Provider.class)) continue;
            LogMessages.LOGGER.info(Messages.MESSAGES.registeringProviderInstance(beanClass.getName()));
            this.providerFactory.registerProviderInstance(binding.getProvider().get());
        }
        for (Binding binding : rootResourceBindings) {
            Class beanClass = (Class)binding.getKey().getTypeLiteral().getType();
            GuiceResourceFactory resourceFactory = new GuiceResourceFactory(binding.getProvider(), beanClass);
            LogMessages.LOGGER.info(Messages.MESSAGES.registeringFactory(beanClass.getName()));
            this.registry.addResourceFactory((ResourceFactory)resourceFactory);
        }
    }
}

