/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.resteasy.plugins.hibernatevalidator.i18n.LogMessages;
import org.jboss.resteasy.plugins.hibernatevalidator.i18n.Messages;
import org.jboss.resteasy.spi.validation.DoNotValidateRequest;
import org.jboss.resteasy.spi.validation.ValidateRequest;
import org.jboss.resteasy.spi.validation.ValidatorAdapter;
import org.jboss.resteasy.util.FindAnnotation;

class HibernateValidatorAdapter
implements ValidatorAdapter {
    private final Validator validator;
    private final MethodValidator methodValidator;
    public static final Annotation STATELESS = new S1(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation STATEFUL = new S2(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation SINGLETON = new S3(){

        public String name() {
            return null;
        }

        public String mappedName() {
            return null;
        }

        public String description() {
            return null;
        }
    };
    public static final Annotation LOCAL = new S4(){

        public Class<?>[] value() {
            return null;
        }
    };
    public static final Annotation REMOTE = new S5(){

        public Class<?>[] value() {
            return null;
        }
    };
    private static final String PROXY_OBJECT_INTERFACE_NAME = "javassist.util.proxy.ProxyObject";
    private static final String TARGET_INSTANCE_INTERFACE_NAME = "org.jboss.interceptor.util.proxy.TargetInstanceProxy";

    HibernateValidatorAdapter(Validator validator) {
        if (validator == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.validatorCannotBeNull());
        }
        this.validator = validator;
        this.methodValidator = (MethodValidator)validator.unwrap(MethodValidator.class);
    }

    public void applyValidation(Object resource, Method invokedMethod, Object[] args) {
        HashSet constraintViolations;
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])invokedMethod.getDeclaringClass().getAnnotations(), ValidateRequest.class);
        if (resourceValidateRequest != null && (constraintViolations = new HashSet(this.validator.validate(resource, resourceValidateRequest.groups()))).size() > 0) {
            throw new ConstraintViolationException(constraintViolations);
        }
        ValidateRequest methodValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])invokedMethod.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])invokedMethod.getAnnotations(), DoNotValidateRequest.class);
        if ((resourceValidateRequest != null || methodValidateRequest != null) && doNotValidateRequest == null) {
            HashSet constraintViolations2;
            HashSet<Class> set = new HashSet<Class>();
            if (resourceValidateRequest != null) {
                for (Class group : resourceValidateRequest.groups()) {
                    set.add(group);
                }
            }
            if (methodValidateRequest != null) {
                for (Class group : methodValidateRequest.groups()) {
                    set.add(group);
                }
            }
            LogMessages.LOGGER.trace("invokedMethod.getDeclaringClass(): " + invokedMethod.getDeclaringClass());
            LogMessages.LOGGER.trace("resource.getClass(): " + resource.getClass());
            if (resourceValidateRequest != null) {
                if ((HibernateValidatorAdapter.isSessionBean(invokedMethod.getDeclaringClass()) || HibernateValidatorAdapter.isSessionBean(resource.getClass())) && !HibernateValidatorAdapter.isWeldProxy(resource.getClass())) {
                    Class<?>[] interfaces = null;
                    interfaces = HibernateValidatorAdapter.isSessionBean(invokedMethod.getDeclaringClass()) ? HibernateValidatorAdapter.getInterfaces(invokedMethod.getDeclaringClass()) : HibernateValidatorAdapter.getInterfaces(resource.getClass());
                    if (interfaces.length > 0) {
                        resource = HibernateValidatorAdapter.getProxy(resource.getClass(), interfaces, resource);
                    }
                }
                if ((constraintViolations2 = new HashSet(this.validator.validate(resource, resourceValidateRequest.groups()))).size() > 0) {
                    throw new ConstraintViolationException(constraintViolations2);
                }
            }
            if ((constraintViolations2 = new HashSet(this.methodValidator.validateAllParameters(resource, invokedMethod, args, set.toArray(new Class[set.size()])))).size() > 0) {
                throw new MethodConstraintViolationException(constraintViolations2);
            }
        }
    }

    private static boolean isSessionBean(Class<?> clazz) {
        if (clazz.getName().indexOf("$$$view") >= 0) {
            return true;
        }
        while (clazz != null) {
            if (clazz.getAnnotation(STATELESS.annotationType()) != null || clazz.getAnnotation(STATEFUL.annotationType()) != null || clazz.getAnnotation(SINGLETON.annotationType()) != null || clazz.getAnnotation(LOCAL.annotationType()) != null || clazz.getAnnotation(REMOTE.annotationType()) != null) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private static Object getProxy(Class<?> clazz, Class<?>[] interfaces, final Object delegate) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(delegate, args);
            }
        };
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, handler);
        return proxy;
    }

    private static boolean isWeldProxy(Class<?> clazz) {
        boolean foundProxyObject = false;
        boolean foundTargetInstance = false;
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (implementedInterface.getName().equals(PROXY_OBJECT_INTERFACE_NAME)) {
                foundProxyObject = true;
            } else if (implementedInterface.getName().equals(TARGET_INSTANCE_INTERFACE_NAME)) {
                foundTargetInstance = true;
            }
            if (!foundProxyObject || !foundTargetInstance) continue;
            return true;
        }
        return clazz.getName().contains("_$$_Weld");
    }

    private static Class<?>[] getInterfaces(Class<?> clazz) {
        ArrayList list = new ArrayList();
        HibernateValidatorAdapter.getInterfaces(list, clazz);
        return list.toArray(new Class[0]);
    }

    private static void getInterfaces(ArrayList<Class<?>> list, Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            list.add(interfaces[i]);
            HibernateValidatorAdapter.getInterfaces(list, interfaces[i]);
        }
    }

    public static abstract class S5
    extends AnnotationLiteral<Remote>
    implements Remote {
    }

    public static abstract class S4
    extends AnnotationLiteral<Local>
    implements Local {
    }

    public static abstract class S3
    extends AnnotationLiteral<Stateful>
    implements Stateful {
    }

    public static abstract class S2
    extends AnnotationLiteral<Stateful>
    implements Stateful {
    }

    public static abstract class S1
    extends AnnotationLiteral<Stateless>
    implements Stateless {
    }
}

