package org.jboss.resteasy.test.resource.param.resource;

import org.jboss.resteasy.test.resource.param.MatrixParamAsPrimitiveTest;
import org.junit.Assert;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;

@Path("/list/default/override")
public class MatrixParamAsPrimitiveListDefaultOverride {
   @GET
   @Produces("application/boolean")
   public String doGetBoolean(@MatrixParam("boolean") @DefaultValue("false") List<Boolean> v) {
      Assert.assertEquals(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, true, v.get(0).booleanValue());
      return "content";
   }

   @GET
   @Produces("application/byte")
   public String doGetByte(@MatrixParam("byte") @DefaultValue("0") List<Byte> v) {
      Assert.assertTrue(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, (byte) 127 == v.get(0).byteValue());
      return "content";
   }

   @GET
   @Produces("application/short")
   public String doGetShort(@MatrixParam("short") @DefaultValue("0") List<Short> v) {
      Assert.assertTrue(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, (short) 32767 == v.get(0).shortValue());
      return "content";
   }

   @GET
   @Produces("application/int")
   public String doGetInteger(@MatrixParam("int") @DefaultValue("0") List<Integer> v) {
      Assert.assertEquals(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, 2147483647, v.get(0).intValue());
      return "content";
   }

   @GET
   @Produces("application/long")
   public String doGetLong(@MatrixParam("long") @DefaultValue("0") List<Long> v) {
      Assert.assertEquals(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, 9223372036854775807L, v.get(0).longValue());
      return "content";
   }

   @GET
   @Produces("application/float")
   public String doGetFloat(@MatrixParam("float") @DefaultValue("0.0") List<Float> v) {
      Assert.assertEquals(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, 3.14159265f, v.get(0).floatValue(), 0.0f);
      return "content";
   }

   @GET
   @Produces("application/double")
   public String doGetDouble(@MatrixParam("double") @DefaultValue("0.0") List<Double> v) {
      Assert.assertEquals(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, 3.14159265358979d, v.get(0).doubleValue(), 0.0);
      return "content";
   }

   @GET
   @Produces("application/char")
   public String doGetCharacter(@MatrixParam("char") @DefaultValue("b")  List<Character> v) {
      Assert.assertEquals(MatrixParamAsPrimitiveTest.ERROR_MESSAGE, 'a', v.get(0).charValue());
      return "content";
   }
}
