/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.util.JSONPObject;
import org.codehaus.jackson.type.JavaType;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.annotations.providers.NoJackson;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

@Provider
@ServerInterceptor
public class JacksonJsonpInterceptor
implements MessageBodyWriterInterceptor {
    public static final MediaType TEXT_JAVASCRIPT_MEDIA_TYPE = new MediaType("text", "javascript");
    public static final MediaType APPLICATION_JAVASCRIPT_MEDIA_TYPE = new MediaType("application", "javascript");
    public static final MediaType TEXT_JSON_TYPE = new MediaType("text", "json");
    public static final MediaType APPLICATION_PLUS_JSON_TYPE = new MediaType("application", "*+json");
    public static final String DEFAULT_CALLBACK_QUERY_PARAMETER = "callback";
    public static final MediaTypeMap<String> jsonpCompatibleMediaTypes = new MediaTypeMap();
    protected static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private UriInfo uri;
    private String callbackQueryParameter = "callback";
    protected ObjectMapper objectMapper;
    protected Providers providers;

    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        for (Annotation annotation : context.getAnnotations()) {
            if (!((Object)annotation).equals(NoJackson.class)) continue;
            context.proceed();
            return;
        }
        String function = (String)this.uri.getQueryParameters().getFirst((Object)this.callbackQueryParameter);
        if (function != null && !function.trim().isEmpty() && !jsonpCompatibleMediaTypes.getPossible(context.getMediaType()).isEmpty()) {
            JSONPObject jsonpEntity;
            Object entity = context.getEntity();
            ObjectMapper mapper = this.getObjectMapper(context.getType(), context.getMediaType());
            if (context.getGenericType() != null && context.getGenericType().getClass() != Class.class) {
                JavaType type = mapper.getTypeFactory().constructType(context.getGenericType());
                jsonpEntity = new JSONPObject(function, entity, type);
            } else {
                JavaType type = mapper.getTypeFactory().constructType((Type)context.getType());
                jsonpEntity = new JSONPObject(function, entity, type);
            }
            context.setEntity((Object)jsonpEntity);
            context.setType(JSONPObject.class);
            context.setGenericType(null);
        }
        context.proceed();
    }

    protected ObjectMapper getObjectMapper(Class<?> type, MediaType mediaType) {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        if (this.providers != null) {
            ContextResolver resolver = this.providers.getContextResolver(ObjectMapper.class, mediaType);
            if (resolver == null) {
                resolver = this.providers.getContextResolver(ObjectMapper.class, null);
            }
            if (resolver != null) {
                return (ObjectMapper)resolver.getContext(type);
            }
        }
        return DEFAULT_MAPPER;
    }

    @Context
    public void setUri(UriInfo uri) {
        this.uri = uri;
    }

    @Context
    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getCallbackQueryParameter() {
        return this.callbackQueryParameter;
    }

    public void setCallbackQueryParameter(String callbackQueryParameter) {
        this.callbackQueryParameter = callbackQueryParameter;
    }

    static {
        jsonpCompatibleMediaTypes.add(MediaType.APPLICATION_JSON_TYPE, (Object)MediaType.APPLICATION_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(APPLICATION_JAVASCRIPT_MEDIA_TYPE, (Object)APPLICATION_JAVASCRIPT_MEDIA_TYPE.toString());
        jsonpCompatibleMediaTypes.add(APPLICATION_PLUS_JSON_TYPE, (Object)APPLICATION_PLUS_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(TEXT_JSON_TYPE, (Object)TEXT_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(TEXT_JAVASCRIPT_MEDIA_TYPE, (Object)TEXT_JAVASCRIPT_MEDIA_TYPE.toString());
    }
}

