/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpRequestPreprocessor;
import org.jboss.resteasy.util.LocaleHelper;

public class ExtensionHttpPreprocessor
implements HttpRequestPreprocessor {
    public Map<String, MediaType> mediaTypeMappings;
    public Map<String, String> languageMappings;

    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    @Override
    public void preProcess(HttpRequest in) {
        List segments = null;
        if (this.mediaTypeMappings != null || this.languageMappings != null) {
            segments = this.process(in, segments);
        }
        if (segments == null) {
            segments = in.getUri().getPathSegments(false);
        }
        StringBuilder preprocessedPath = new StringBuilder();
        for (PathSegment pathSegment : segments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        in.setPreprocessedPath(preprocessedPath.toString());
    }

    private List<PathSegment> process(HttpRequest in, List<PathSegment> segments) {
        int index;
        String path = in.getUri().getPath(false);
        int lastSegment = path.lastIndexOf(47);
        if (lastSegment < 0) {
            lastSegment = 0;
        }
        if ((index = path.indexOf(46, lastSegment)) < 0) {
            return null;
        }
        boolean preprocessed = false;
        String extension = path.substring(index + 1);
        String[] extensions = extension.split("\\.");
        StringBuilder rebuilt = new StringBuilder(path.substring(0, index));
        for (String ext : extensions) {
            Object match;
            if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                in.getHttpHeaders().getAcceptableMediaTypes().add(0, match);
                preprocessed = true;
                continue;
            }
            if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                in.getHttpHeaders().getAcceptableLanguages().add(LocaleHelper.extractLocale((String)match));
                preprocessed = true;
                continue;
            }
            rebuilt.append(".").append(ext);
        }
        if (preprocessed) {
            segments = PathSegmentImpl.parseSegments(rebuilt.toString());
        }
        return segments;
    }
}

