/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsServer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.HttpHeadersImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.PathHelper;

public class HttpExchangeUtil {
    public static UriInfoImpl extractUriInfo(HttpExchange exchange) {
        String host = exchange.getLocalAddress().getHostName();
        if (exchange.getLocalAddress().getPort() != 80 && exchange.getLocalAddress().getPort() != 443) {
            host = host + ":" + exchange.getLocalAddress().getPort();
        }
        String uri = exchange.getRequestURI().toString();
        String protocol = exchange.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
        URI absolutePath = null;
        try {
            URL absolute = new URL(protocol + "://" + host + uri);
            UriBuilderImpl builder = new UriBuilderImpl();
            builder.scheme(absolute.getProtocol());
            builder.host(absolute.getHost());
            builder.port(absolute.getPort());
            builder.path(absolute.getPath());
            builder.replaceQuery(absolute.getQuery());
            absolutePath = builder.build(new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String contextPath = exchange.getHttpContext().getPath();
        String path = PathHelper.getEncodedPathInfo((String)absolutePath.getRawPath(), (String)contextPath);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        List pathSegments = PathSegmentImpl.parseSegments((String)path, (boolean)false);
        URI baseURI = absolutePath;
        if (!path.trim().equals("")) {
            String tmpContextPath = contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            baseURI = UriBuilder.fromUri((URI)absolutePath).replacePath(tmpContextPath).build(new Object[0]);
        }
        UriInfoImpl uriInfo = new UriInfoImpl(absolutePath, baseURI, path, absolutePath.getRawQuery(), pathSegments);
        return uriInfo;
    }

    public static HttpHeaders extractHttpHeaders(HttpExchange request) {
        HttpHeadersImpl headers = new HttpHeadersImpl();
        MultivaluedMap<String, String> requestHeaders = HttpExchangeUtil.extractRequestHeaders(request);
        headers.setRequestHeaders(requestHeaders);
        List<MediaType> acceptableMediaTypes = HttpExchangeUtil.extractAccepts(requestHeaders);
        List<String> acceptableLanguages = HttpExchangeUtil.extractLanguages(requestHeaders);
        headers.setAcceptableMediaTypes(acceptableMediaTypes);
        headers.setAcceptableLanguages(acceptableLanguages);
        headers.setLanguage((String)requestHeaders.getFirst((Object)"Content-Language"));
        String contentType = (String)requestHeaders.getFirst((Object)"Content-Type");
        if (contentType != null) {
            headers.setMediaType(MediaType.valueOf((String)contentType));
        }
        Map<String, Cookie> cookies = HttpExchangeUtil.extractCookies(requestHeaders);
        headers.setCookies(cookies);
        return headers;
    }

    static Map<String, Cookie> extractCookies(MultivaluedMap<String, String> headers) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeaders = (List)headers.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return cookies;
        }
        for (String cookieVal : cookieHeaders) {
            Cookie cookie = Cookie.valueOf((String)cookieVal);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader((String)accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpExchange request) {
        Headers requestHeaders = new Headers();
        for (Map.Entry<String, List<String>> header : request.getRequestHeaders().entrySet()) {
            for (String val : header.getValue()) {
                requestHeaders.add(header.getKey(), (Object)val);
            }
        }
        return requestHeaders;
    }
}

